/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@Actions(value={@Action(method=RequestMethod.PUT, name="copy", description="Copy an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="folder", description="The Folder of the Object."), @Parameter(name="timestamp", description="Timestamp of the infostore object.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present.", responseDescription="The id of the newly created object."), @Action(method=RequestMethod.POST, name="copy", description="Copy an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="The response is sent as a HTML document (see introduction).")})
public class CopyAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        List<IdVersionPair> pairs = request.optIdVersionPairs();
        if (null != pairs) {
            return this.handlePairs(pairs, request);
        }
        request.require(AbstractFileAction.Param.ID).requireFileMetadata();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        String id = request.getId();
        File file = request.getFile();
        String folder = null != file.getFolderId() ? file.getFolderId() : request.getFolderId();
        String version = request.getVersion();
        String newId = request.hasUploads() ? fileAccess.copy(id, version, folder, file, request.getUploadedFileData(), request.getSentColumns()) : fileAccess.copy(id, version, folder, file, null, request.getSentColumns());
        return new AJAXRequestResult((Object)newId, new Date(file.getSequenceNumber()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult handlePairs(List<IdVersionPair> pairs, InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.FOLDER_ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        IDBasedFolderAccess folderAccess = request.getFolderAccess();
        String destFolder = request.getFolderId();
        LinkedList<String> newFiles = new LinkedList<String>();
        LinkedList<String> newFolders = new LinkedList<String>();
        boolean error = true;
        try {
            for (IdVersionPair pair : pairs) {
                if (pair.getIdentifier() == null) {
                    String folderId = pair.getFolderId();
                    FileStorageFolder srcFolder = folderAccess.getFolder(new FolderID(folderId));
                    DefaultFileStorageFolder newFolder = new DefaultFileStorageFolder();
                    newFolder.setName(srcFolder.getName());
                    newFolder.setParentId(destFolder);
                    newFolder.setSubscribed(srcFolder.isSubscribed());
                    for (FileStoragePermission permission : srcFolder.getPermissions()) {
                        newFolder.addPermission(permission);
                    }
                    String newFolderID = folderAccess.createFolder((FileStorageFolder)newFolder);
                    newFolders.add(newFolderID);
                    TimedResult documents = fileAccess.getDocuments(folderId);
                    SearchIterator iter = documents.results();
                    try {
                        while (iter.hasNext()) {
                            File file = (File)iter.next();
                            fileAccess.copy(file.getId(), file.getVersion(), newFolderID, null, null, null);
                        }
                        continue;
                    }
                    finally {
                        SearchIterators.close((SearchIterator)iter);
                        continue;
                    }
                }
                String id = pair.getIdentifier();
                String version = pair.getVersion();
                String newFileId = fileAccess.copy(id, version, destFolder, null, null, null);
                newFiles.add(newFileId);
            }
            error = false;
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
            return aJAXRequestResult;
        }
        finally {
            if (error) {
                for (String folderId : newFolders) {
                    try {
                        folderAccess.deleteFolder(folderId, true);
                    }
                    catch (Exception e) {}
                }
                for (String fileId : newFiles) {
                    try {
                        fileAccess.removeDocument(Collections.singletonList(fileId), Long.MAX_VALUE, true);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

