/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.Range;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractListingAction;
import com.openexchange.file.storage.json.actions.files.CreatedByComparator;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.groupware.results.Results;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.java.Strings;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@Action(method=RequestMethod.GET, name="all", description="Get all infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for infoitems are defined in Common object data and Detailed infoitem data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="Response with timestamp: An array with infoitem data. Each array element describes one infoitem and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public class AllAction
extends AbstractListingAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        DelegatingTimedResult documents;
        request.require(AbstractFileAction.Param.FOLDER_ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        String folderId = request.getFolderId();
        if (Strings.isEmpty((String)folderId)) {
            throw FileStorageExceptionCodes.MISSING_PARAMETER.create(new Object[]{AbstractFileAction.Param.FOLDER_ID.getName()});
        }
        File.Field sortingField = request.getSortingField();
        FileStorageFileAccess.SortDirection sortingOrder = request.getSortingOrder();
        int[] indexes = AJAXRequestDataTools.parseFromToIndexes((AJAXRequestData)request.getRequestData());
        List<File.Field> columns = request.getFieldsToLoad();
        boolean copy = false;
        if (!columns.contains(File.Field.FOLDER_ID)) {
            columns = new ArrayList<File.Field>(columns);
            columns.add(File.Field.FOLDER_ID);
            copy = true;
        }
        if (!columns.contains(File.Field.ID)) {
            if (!copy) {
                columns = new ArrayList<File.Field>(columns);
                copy = true;
            }
            columns.add(File.Field.ID);
        }
        if (null == indexes || File.Field.CREATED_BY.equals((Object)sortingField)) {
            documents = fileAccess.getDocuments(folderId, columns, sortingField, sortingOrder);
            if (File.Field.CREATED_BY.equals((Object)sortingField)) {
                ServerSession serverSession = request.getSession();
                CreatedByComparator comparator = new CreatedByComparator(serverSession.getUser().getLocale(), serverSession.getContext()).setDescending(FileStorageFileAccess.SortDirection.DESC.equals((Object)sortingOrder));
                SearchIterator<File> iter = CreatedByComparator.resort((SearchIterator<File>)documents.results(), comparator);
                documents = new DelegatingTimedResult(iter, documents.sequenceNumber());
            }
            if (null != indexes) {
                documents = this.slice(documents, indexes);
            }
        } else {
            documents = fileAccess.getDocuments(folderId, columns, sortingField, sortingOrder, Range.valueOf((int[])indexes));
        }
        return this.result(documents, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedResult<File> slice(TimedResult<File> documents, int[] indexes) throws OXException {
        if (null == indexes) {
            return documents;
        }
        int from = indexes[0];
        int to = indexes[1];
        if (from >= to) {
            return Results.emptyTimedResult();
        }
        SearchIterator iter = documents.results();
        try {
            int index;
            for (index = 0; index < from; ++index) {
                if (!iter.hasNext()) {
                    TimedResult timedResult = Results.emptyTimedResult();
                    return timedResult;
                }
                iter.next();
            }
            LinkedList<File> files = new LinkedList<File>();
            while (index < to && iter.hasNext()) {
                files.add((File)iter.next());
                ++index;
            }
            ListBasedTimedResult listBasedTimedResult = new ListBasedTimedResult(files, documents.sequenceNumber());
            return listBasedTimedResult;
        }
        finally {
            SearchIterators.close((SearchIterator)iter);
        }
    }

    private final class DelegatingTimedResult
    implements TimedResult<File> {
        private final long sequenceNumber;
        private final SearchIterator<File> results;

        DelegatingTimedResult(SearchIterator<File> results, long sequenceNumber) {
            this.results = results;
            this.sequenceNumber = sequenceNumber;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public SearchIterator<File> results() throws OXException {
            return this.results;
        }
    }

    private final class ListBasedTimedResult
    implements TimedResult<File> {
        private final long sequenceNumber;
        private final SearchIterator<File> results;

        ListBasedTimedResult(List<File> files, long sequenceNumber) {
            this.results = new SearchIteratorDelegator(files);
            this.sequenceNumber = sequenceNumber;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public SearchIterator<File> results() throws OXException {
            return this.results;
        }
    }
}

