/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.customizer.file.AdditionalFileField;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Document;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.FileMetadataParser;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.osgi.FileFieldCollector;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.infostore.utils.InfostoreConfigUtils;
import com.openexchange.groupware.infostore.utils.UploadSizeValidation;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.java.FileKnowingInputStream;
import com.openexchange.java.Strings;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.session.Session;
import com.openexchange.share.notification.ShareNotificationService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AJAXInfostoreRequest
implements InfostoreRequest {
    private static final String PARAM_TIMEZONE = AbstractFileAction.Param.TIMEZONE.getName();
    private static final String PARAM_TIMESTAMP = AbstractFileAction.Param.TIMESTAMP.getName();
    private static final String PARAM_ORDER = AbstractFileAction.Param.ORDER.getName();
    private static final String PARAM_SORT = AbstractFileAction.Param.SORT.getName();
    private static final String PARAM_COLUMNS = AbstractFileAction.Param.COLUMNS.getName();
    private static final String PARAM_VERSION = AbstractFileAction.Param.VERSION.getName();
    private static final String PARAM_ID = AbstractFileAction.Param.ID.getName();
    private static final String PARAM_FOLDER_ID = AbstractFileAction.Param.FOLDER_ID.getName();
    private static final String JSON = "json";
    private final ServerSession session;
    private List<File.Field> fieldsToLoad;
    private int[] requestedColumns;
    private byte[] contentData;
    private List<File.Field> fields;
    private File file;
    private IDBasedFileAccess fileAccess;
    private IDBasedFolderAccess folderAccess;
    private Map<String, String> folderMapping;
    private Map<String, Set<String>> versionMapping;
    private List<String> folders;
    private List<String> ids;
    private File.Field sortingField;
    private String[] versions;
    private boolean notifyPermissionEntities;
    private ShareNotificationService.Transport notificationTransport;
    private String notificationMessage;
    protected AJAXRequestData data;

    public AJAXInfostoreRequest(AJAXRequestData requestData, ServerSession session) {
        this.data = requestData;
        this.session = session;
    }

    @Override
    public AJAXRequestData getRequestData() {
        return this.data;
    }

    @Override
    public boolean extendedResponse() throws OXException {
        return this.data.isSet("extendedResponse") && (Boolean)this.data.getParameter("extendedResponse", Boolean.class) != false;
    }

    @Override
    public int getAttachedId() {
        return this.getInt(AbstractFileAction.Param.ATTACHED_ID);
    }

    @Override
    public int getAttachment() {
        return this.getInt(AbstractFileAction.Param.ATTACHMENT);
    }

    @Override
    public AttachmentBase getAttachmentBase() {
        return Services.getAttachmentBase();
    }

    @Override
    public boolean getBoolParameter(String name) {
        return AJAXRequestDataTools.parseBoolParameter((String)name, (AJAXRequestData)this.data);
    }

    @Override
    public List<File.Field> getFieldsToLoad() throws OXException {
        if (null == this.fieldsToLoad) {
            this.parseColumns();
        }
        return this.fieldsToLoad;
    }

    @Override
    public int[] getRequestedColumns() throws OXException {
        if (null == this.requestedColumns) {
            this.parseColumns();
        }
        return this.requestedColumns;
    }

    @Override
    public long getDiff() {
        String parameter = this.data.getParameter(AbstractFileAction.Param.DIFF.getName());
        if (parameter == null) {
            return -1L;
        }
        return Long.parseLong(parameter);
    }

    @Override
    public int getEnd() throws OXException {
        String parameter = this.data.getParameter("end");
        if (parameter == null) {
            parameter = this.data.getParameter("limit");
            if (parameter == null) {
                return -11;
            }
            try {
                return Integer.parseInt(parameter) - 1;
            }
            catch (NumberFormatException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create((Throwable)e, new Object[]{"limit", parameter});
            }
        }
        try {
            return Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create((Throwable)e, new Object[]{"end", parameter});
        }
    }

    @Override
    public File getFile() throws OXException {
        this.parseFile();
        return this.file;
    }

    @Override
    public IDBasedFileAccess getFileAccess() {
        if (this.fileAccess != null) {
            return this.fileAccess;
        }
        this.fileAccess = Services.getFileAccessFactory().createAccess((Session)this.session);
        return this.fileAccess;
    }

    @Override
    public IDBasedFileAccess optFileAccess() {
        return this.fileAccess;
    }

    @Override
    public IDBasedFolderAccess getFolderAccess() throws OXException {
        if (this.folderAccess != null) {
            return this.folderAccess;
        }
        this.folderAccess = Services.getFolderAccessFactory().createAccess((Session)this.session);
        return this.folderAccess;
    }

    @Override
    public IDBasedFolderAccess optFolderAccess() {
        return this.folderAccess;
    }

    @Override
    public String getFolderAt(int index) {
        return index < 0 || index >= this.folders.size() ? null : this.folders.get(index);
    }

    @Override
    public String getFolderForID(String id) throws OXException {
        this.parseIDList(true);
        return this.folderMapping.get(id);
    }

    @Override
    public String getFolderId() throws OXException {
        String parameter = this.data.getParameter(PARAM_FOLDER_ID);
        if (parameter == null || parameter.equals("null") || parameter.equals("undefined")) {
            return FileStorageFileAccess.ALL_FOLDERS;
        }
        return parameter;
    }

    @Override
    public List<String> getFolders() {
        return this.folders;
    }

    @Override
    public String getId() {
        return this.data.getParameter(PARAM_ID);
    }

    @Override
    public List<String> getIds() throws OXException {
        this.parseIDList(true);
        return this.ids;
    }

    @Override
    public List<IdVersionPair> getIdVersionPairs() throws OXException {
        this.parseIDList(true);
        return this.generateIdVersionPairs();
    }

    @Override
    public List<IdVersionPair> optIdVersionPairs() throws OXException {
        return this.parseIDList(false) ? this.generateIdVersionPairs() : null;
    }

    private List<IdVersionPair> generateIdVersionPairs() {
        int size = this.ids.size();
        ArrayList<IdVersionPair> retval = new ArrayList<IdVersionPair>(size);
        int i = size;
        int pos = 0;
        while (i-- > 0) {
            String id = this.ids.get(pos);
            if (null == id) {
                retval.add(new IdVersionPair(null, null, this.folders.get(pos)));
            } else {
                Set<String> versions = this.versionMapping.get(id);
                if (null == versions) {
                    retval.add(new IdVersionPair(id, FileStorageFileAccess.CURRENT_VERSION, this.folderMapping.get(id)));
                } else {
                    for (String version : versions) {
                        retval.add(new IdVersionPair(id, version, this.folderMapping.get(id)));
                    }
                }
            }
            ++pos;
        }
        return retval;
    }

    @Override
    public Set<String> getIgnore() {
        String parameter = this.data.getParameter(AbstractFileAction.Param.IGNORE.getName());
        if (parameter == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(Strings.splitByComma((String)parameter)));
    }

    @Override
    public int getModule() {
        return this.getInt(AbstractFileAction.Param.MODULE);
    }

    @Override
    public String getParameter(String name) {
        return this.data.getParameter(name);
    }

    @Override
    public String getSearchFolderId() throws OXException {
        return this.getFolderId();
    }

    @Override
    public String getSearchQuery() throws OXException {
        Object data2 = this.data.getData();
        if (data2 == null) {
            return "";
        }
        JSONObject queryObject = (JSONObject)data2;
        try {
            return queryObject.getString("pattern");
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
    }

    @Override
    public List<File.Field> getSentColumns() throws OXException {
        this.parseFile();
        return this.fields;
    }

    @Override
    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public File.Field getSortingField() throws OXException {
        if (this.sortingField != null) {
            return this.sortingField;
        }
        String sort = this.data.getParameter(PARAM_SORT);
        if (sort == null) {
            return null;
        }
        this.sortingField = File.Field.get((String)sort);
        File.Field field = this.sortingField;
        if (field == null) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{PARAM_SORT, sort});
        }
        return field;
    }

    @Override
    public FileStorageFileAccess.SortDirection getSortingOrder() throws OXException {
        FileStorageFileAccess.SortDirection sortDirection = FileStorageFileAccess.SortDirection.get((String)this.data.getParameter(PARAM_ORDER));
        if (sortDirection == null) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{PARAM_ORDER, sortDirection});
        }
        return sortDirection;
    }

    @Override
    public int getStart() throws OXException {
        String parameter = this.data.getParameter("start");
        if (parameter == null) {
            if (this.data.getParameter("limit") != null) {
                return 0;
            }
            return -11;
        }
        try {
            return Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create((Throwable)e, new Object[]{"start", parameter});
        }
    }

    @Override
    public long getTimestamp() {
        String parameter = this.data.getParameter(PARAM_TIMESTAMP);
        if (parameter == null) {
            return -1L;
        }
        return Long.parseLong(parameter);
    }

    @Override
    public TimeZone getTimezone() {
        String parameter = this.data.getParameter(PARAM_TIMEZONE);
        if (parameter == null) {
            parameter = this.getSession().getUser().getTimeZone();
        }
        return TimeZone.getTimeZone(parameter);
    }

    @Override
    public InputStream getUploadedFileData() throws OXException {
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        if (this.data.hasUploads(-1L, maxSize > 0L ? maxSize : -1L)) {
            try {
                UploadFile uploadFile = (UploadFile)this.data.getFiles(-1L, maxSize > 0L ? maxSize : -1L).get(0);
                UploadSizeValidation.checkSize((long)uploadFile.getSize());
                java.io.File tmpFile = uploadFile.getTmpFile();
                return new FileKnowingInputStream((InputStream)new FileInputStream(tmpFile), tmpFile);
            }
            catch (FileNotFoundException e) {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        if (this.contentData != null) {
            return new UnsynchronizedByteArrayInputStream(this.contentData);
        }
        return null;
    }

    @Override
    public InputStream getUploadStream() throws OXException {
        try {
            return this.data.getUploadStream();
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public String getVersion() {
        String parameter = this.data.getParameter(PARAM_VERSION);
        if (parameter == null) {
            return FileStorageFileAccess.CURRENT_VERSION;
        }
        return "null".equalsIgnoreCase(parameter) ? FileStorageFileAccess.CURRENT_VERSION : parameter;
    }

    @Override
    public String[] getVersions() throws OXException {
        if (this.versions != null) {
            return this.versions;
        }
        JSONArray body = this.getBodyAsJsonArray();
        try {
            this.versions = new String[body.length()];
            for (int i = 0; i < this.versions.length; ++i) {
                this.versions[i] = body.getString(i);
            }
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
        return this.versions;
    }

    public boolean has(String paramName) {
        return this.data.getParameter(paramName) != null;
    }

    @Override
    public boolean hasUploads() throws OXException {
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        return this.data.hasUploads(-1L, maxSize > 0L ? maxSize : -1L) || this.contentData != null;
    }

    @Override
    public boolean isForSpecificVersion() {
        return this.getVersion() != FileStorageFileAccess.CURRENT_VERSION;
    }

    @Override
    public InfostoreRequest require(AbstractFileAction.Param ... params) throws OXException {
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = params[i].getName();
        }
        List missingParameters = this.data.getMissingParameters(names);
        if (!missingParameters.isEmpty()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{missingParameters.toString()});
        }
        return this;
    }

    @Override
    public InfostoreRequest requireBody() throws OXException {
        long maxSize;
        if (this.data.getData() == null && !this.data.hasUploads(-1L, (maxSize = InfostoreConfigUtils.determineRelevantUploadSize()) > 0L ? maxSize : -1L) && this.data.getParameter(JSON) == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"data"});
        }
        return this;
    }

    @Override
    public InfostoreRequest requireFileMetadata() throws OXException {
        return this.requireBody();
    }

    @Override
    public Document getCachedDocument() {
        return (Document)this.data.getProperty("com.openexchange.file.storage.json.DocumentAction.DOCUMENT");
    }

    @Override
    public boolean notifyPermissionEntities() throws OXException {
        this.parseNotification();
        return this.notifyPermissionEntities;
    }

    @Override
    public ShareNotificationService.Transport getNotificationTransport() throws OXException {
        this.parseNotification();
        return this.notificationTransport;
    }

    @Override
    public String getNotifiactionMessage() throws OXException {
        this.parseNotification();
        return this.notificationMessage;
    }

    @Override
    public List<Integer> getEntities() throws OXException {
        JSONObject data = this.getBodyAsJSONObject();
        if (!data.hasAndNotNull("entities")) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"entities"});
        }
        try {
            JSONArray jsonArray = data.getJSONArray("entities");
            ArrayList<Integer> entityIDs = new ArrayList<Integer>(jsonArray.length());
            entityIDs = new ArrayList();
            for (int i = 0; i < jsonArray.length(); ++i) {
                entityIDs.add(jsonArray.getInt(i));
            }
            if (0 >= entityIDs.size()) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"entities"});
            }
            return entityIDs;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private int getInt(AbstractFileAction.Param param) {
        return Integer.parseInt(this.data.getParameter(param.getName()));
    }

    private boolean parseIDList(boolean required) throws OXException {
        try {
            JSONArray array;
            if (this.ids != null) {
                return true;
            }
            if (required) {
                array = this.getBodyAsJsonArray();
            } else {
                array = this.optBodyAsJsonArray();
                if (null == array) {
                    return false;
                }
            }
            int length = array.length();
            ArrayList<String> ids = new ArrayList<String>(length);
            ArrayList<String> folders = new ArrayList<String>(length);
            HashMap<String, String> folderMapping = new HashMap<String, String>(length);
            HashMap<String, Set<String>> versionMapping = new HashMap<String, Set<String>>(length);
            int i = length;
            int pos = 0;
            while (i-- > 0) {
                JSONObject tuple = array.getJSONObject(pos);
                String folderId = tuple.optString(PARAM_FOLDER_ID, null);
                folders.add(folderId);
                String id = tuple.optString(PARAM_ID, null);
                if (null == id) {
                    ids.add(id);
                } else {
                    FileID fileID = new FileID(id);
                    if (fileID.getFolderId() == null) {
                        fileID.setFolderId(folderId);
                        ids.add(fileID.toUniqueID());
                    } else {
                        ids.add(id);
                    }
                    folderMapping.put(id, folderId);
                    String version = tuple.optString(PARAM_VERSION, FileStorageFileAccess.CURRENT_VERSION);
                    LinkedHashSet<String> list = (LinkedHashSet<String>)versionMapping.get(id);
                    if (null == list) {
                        list = new LinkedHashSet<String>(2);
                        versionMapping.put(id, list);
                    }
                    list.add(version);
                }
                ++pos;
            }
            this.ids = ids;
            this.folders = folders;
            this.folderMapping = folderMapping;
            this.versionMapping = versionMapping;
            return true;
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
    }

    private JSONArray getBodyAsJsonArray() throws OXException {
        Object obj = this.data.requireData();
        if (!(obj instanceof JSONArray)) {
            try {
                return new JSONArray(obj.toString());
            }
            catch (Exception e) {
                throw AjaxExceptionCodes.INVALID_REQUEST_BODY.create(new Object[]{JSONArray.class.getSimpleName(), obj.getClass().getSimpleName()});
            }
        }
        return (JSONArray)obj;
    }

    private JSONArray optBodyAsJsonArray() throws OXException {
        Object obj = this.data.getData();
        if (null == obj) {
            return null;
        }
        if (!(obj instanceof JSONArray)) {
            try {
                return new JSONArray(obj.toString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return (JSONArray)obj;
    }

    protected void parseNotification() throws OXException {
        JSONObject object;
        JSONObject jNotification;
        if (null == this.notificationTransport && (jNotification = (object = this.getBodyAsJSONObject()).optJSONObject("notification")) != null) {
            ShareNotificationService.Transport transport = ShareNotificationService.Transport.MAIL;
            if (jNotification.hasAndNotNull("transport")) {
                try {
                    transport = ShareNotificationService.Transport.forID((String)jNotification.getString("transport"));
                    if (transport == null) {
                        throw AjaxExceptionCodes.INVALID_JSON_REQUEST_BODY.create();
                    }
                }
                catch (JSONException e) {
                    throw AjaxExceptionCodes.INVALID_JSON_REQUEST_BODY.create((Throwable)e, new Object[0]);
                }
            }
            this.notificationTransport = transport;
            this.notifyPermissionEntities = true;
            String message = jNotification.optString("message", null);
            if (Strings.isNotEmpty((String)message)) {
                this.notificationMessage = message;
            }
        }
    }

    private JSONObject getBodyAsJSONObject() throws OXException {
        JSONObject object = (JSONObject)this.data.getData();
        if (object == null) {
            try {
                object = new JSONObject(this.data.getParameter(JSON));
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{e.getMessage()});
            }
        }
        return object;
    }

    protected void parseFile() throws OXException {
        String fileDisplay;
        List list;
        JSONObject jFile;
        if (this.file != null) {
            return;
        }
        this.requireFileMetadata();
        JSONObject object = this.getBodyAsJSONObject();
        if (object.hasAndNotNull("file")) {
            try {
                jFile = object.getJSONObject("file");
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.INVALID_JSON_REQUEST_BODY.create((Throwable)e, new Object[0]);
            }
        } else {
            jFile = object;
        }
        UploadFile uploadFile = null;
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        if (this.data.hasUploads(-1L, maxSize > 0L ? maxSize : -1L)) {
            uploadFile = (UploadFile)this.data.getFiles(-1L, maxSize > 0L ? maxSize : -1L).get(0);
        }
        if (this.data.getUploadEvent() != null && (list = this.data.getUploadEvent().getUploadFilesByFieldName("file")) != null && !list.isEmpty()) {
            uploadFile = (UploadFile)list.get(0);
        }
        FileMetadataParser parser = FileMetadataParser.getInstance();
        this.file = parser.parse(jFile);
        this.fields = parser.getFields(jFile);
        if (uploadFile != null) {
            if (!this.fields.contains(File.Field.FILENAME) || this.file.getFileName() == null || this.file.getFileName().trim().length() == 0) {
                this.file.setFileName(uploadFile.getPreparedFileName());
                this.fields.add(File.Field.FILENAME);
            }
            if (!this.fields.contains(File.Field.FILE_MIMETYPE)) {
                this.file.setFileMIMEType(uploadFile.getContentType());
                this.fields.add(File.Field.FILE_MIMETYPE);
            }
            this.file.setFileSize(uploadFile.getSize());
            this.fields.add(File.Field.FILE_SIZE);
        }
        if ((fileDisplay = this.data.getParameter("filedisplay")) != null && fileDisplay.trim().length() > 0 && (this.file.getFileName() == null || this.file.getFileName().trim().length() == 0)) {
            this.file.setFileName(fileDisplay);
            this.fields.add(File.Field.FILENAME);
        }
        if (this.has("id") && !this.fields.contains(File.Field.ID)) {
            this.file.setId(this.getId());
            this.fields.add(File.Field.ID);
        }
        if (jFile.has("content")) {
            try {
                this.contentData = jFile.opt("content").toString().getBytes("UTF-8");
                this.file.setFileSize((long)this.contentData.length);
                this.fields.add(File.Field.FILE_SIZE);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    private void parseColumns() throws OXException {
        String columnsParameter = this.data.getParameter(PARAM_COLUMNS);
        if (Strings.isEmpty((String)columnsParameter)) {
            this.fieldsToLoad = Arrays.asList(File.Field.values());
            this.requestedColumns = new int[this.fieldsToLoad.size()];
            for (int i = 0; i < this.requestedColumns.length; ++i) {
                this.requestedColumns[i] = this.fieldsToLoad.get(i).getNumber();
            }
        } else {
            ArrayList<String> unknownColumns = new ArrayList<String>(0);
            String[] columns = Strings.splitByComma((String)columnsParameter);
            this.fieldsToLoad = new ArrayList<File.Field>(columns.length);
            this.requestedColumns = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                AdditionalFileField additionalField;
                File.Field field = File.Field.get((String)columns[i]);
                if (null != field) {
                    this.fieldsToLoad.add(field);
                    this.requestedColumns[i] = field.getNumber();
                    continue;
                }
                FileFieldCollector fieldCollector = Services.getFieldCollector();
                if (null != fieldCollector && null != (additionalField = fieldCollector.getField(columns[i]))) {
                    File.Field[] requiredFields = additionalField.getRequiredFields();
                    if (null != requiredFields && 0 < requiredFields.length) {
                        this.fieldsToLoad.addAll(Arrays.asList(requiredFields));
                    }
                    this.requestedColumns[i] = additionalField.getColumnID();
                    continue;
                }
                unknownColumns.add(columns[i]);
            }
            if (0 < unknownColumns.size()) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{PARAM_COLUMNS, ((Object)unknownColumns).toString()});
            }
        }
    }
}

