/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.json.FormContentWriter;
import com.openexchange.datatypes.genericonf.json.FormDescriptionWriter;
import com.openexchange.exception.Categories;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccounts;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.Localizable;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileStorageAccountWriter {
    public static final String ERROR = "error";
    public static final String ERROR_CATEGORIES = "categories";
    public static final String ERROR_CATEGORY = "category";
    public static final String ERROR_CODE = "code";
    public static final String ERROR_ID = "error_id";
    public static final String ERROR_PARAMS = "error_params";
    public static final String ERROR_STACK = "error_stack";
    public static final String ERROR_DESC = "error_desc";

    public JSONObject write(FileStorageAccount account, FileStorageFolder rootFolder, Set<String> capabilities) throws JSONException {
        JSONObject accountJSON = new JSONObject(7);
        accountJSON.put("id", (Object)account.getId());
        FileStorageService fsService = account.getFileStorageService();
        accountJSON.put("qualifiedId", (Object)FileStorageAccounts.getQualifiedID((FileStorageAccount)account));
        accountJSON.put("displayName", (Object)account.getDisplayName());
        accountJSON.put("filestorageService", (Object)fsService.getId());
        accountJSON.put("rootFolder", (Object)new FolderID(fsService.getId(), account.getId(), rootFolder.getId()).toUniqueID());
        accountJSON.put("isDefaultAccount", FileStorageAccounts.isDefaultAccount((FileStorageAccount)account));
        DynamicFormDescription formDescription = fsService.getFormDescription();
        if (null != formDescription && null != account.getConfiguration()) {
            JSONObject configJSON = FormContentWriter.write((DynamicFormDescription)formDescription, (Map)account.getConfiguration(), null);
            accountJSON.put("configuration", (Object)configJSON);
        }
        if (capabilities == null) {
            capabilities = new HashSet<String>(0);
        }
        accountJSON.put("capabilities", capabilities);
        return accountJSON;
    }

    public JSONObject write(FileStorageAccount account, FileStorageFolder rootFolder, Set<String> capabilities, OXException exception, Session session) throws JSONException {
        JSONObject accountJSON = new JSONObject(7);
        accountJSON.put("id", (Object)account.getId());
        FileStorageService fsService = account.getFileStorageService();
        accountJSON.put("qualifiedId", (Object)FileStorageAccounts.getQualifiedID((FileStorageAccount)account));
        accountJSON.put("displayName", (Object)account.getDisplayName());
        accountJSON.put("filestorageService", (Object)fsService.getId());
        if (rootFolder != null) {
            accountJSON.put("rootFolder", (Object)new FolderID(fsService.getId(), account.getId(), rootFolder.getId()).toUniqueID());
        }
        accountJSON.put("isDefaultAccount", FileStorageAccounts.isDefaultAccount((FileStorageAccount)account));
        DynamicFormDescription formDescription = fsService.getFormDescription();
        if (null != formDescription && null != account.getConfiguration()) {
            JSONObject configJSON = FormContentWriter.write((DynamicFormDescription)formDescription, (Map)account.getConfiguration(), null);
            accountJSON.put("configuration", (Object)configJSON);
        }
        if (capabilities == null) {
            capabilities = new HashSet<String>(0);
        }
        accountJSON.put("capabilities", capabilities);
        accountJSON.put("hasError", true);
        accountJSON.put(ERROR, (Object)exception);
        FileStorageAccountWriter.addException(accountJSON, ERROR, exception, FileStorageAccountWriter.localeFrom(session));
        return accountJSON;
    }

    private static Locale localeFrom(Session session) {
        if (null == session) {
            return Locale.US;
        }
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        try {
            return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLocale();
        }
        catch (OXException e) {
            return Locale.US;
        }
    }

    public static void addException(JSONObject json, String errorKey, OXException exception, Locale locale) throws JSONException {
        Locale parsedLocale;
        String property = exception.getProperty("com.openexchange.exception.locale");
        Locale l = null == property ? LocaleTools.getSaneLocale((Locale)locale) : (null == (parsedLocale = LocaleTools.getLocale((String)property)) ? LocaleTools.getSaneLocale((Locale)locale) : parsedLocale);
        json.put(errorKey, (Object)exception.getDisplayMessage(l));
        Object[] args = exception.getLogArgs();
        if (null == args || 0 == args.length) {
            args = exception.getDisplayArgs();
        }
        if (null == args || 0 == args.length) {
            json.put(ERROR_PARAMS, (Object)new JSONArray(0));
        } else {
            JSONArray jArgs = new JSONArray(args.length);
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                if (obj == null) continue;
                jArgs.put(obj instanceof Localizable ? obj.toString() : obj);
            }
            json.put(ERROR_PARAMS, (Object)jArgs);
        }
        List categories = exception.getCategories();
        int size = categories.size();
        if (1 == size) {
            Category category = (Category)categories.get(0);
            json.put(ERROR_CATEGORIES, (Object)category.toString());
            int number = Categories.getFormerCategoryNumber((Category)category);
            if (number > 0) {
                json.put(ERROR_CATEGORY, number);
            }
        } else if (size <= 0) {
            json.put(ERROR_CATEGORIES, (Object)new JSONArray(0));
        } else {
            JSONArray jArray = new JSONArray(size);
            for (Category category : categories) {
                jArray.put((Object)category.toString());
            }
            json.put(ERROR_CATEGORIES, (Object)jArray);
            int number = Categories.getFormerCategoryNumber((Category)((Category)categories.get(0)));
            if (number > 0) {
                json.put(ERROR_CATEGORY, number);
            }
        }
        json.put(ERROR_CODE, (Object)exception.getErrorCode());
        json.put(ERROR_ID, (Object)exception.getExceptionId());
        json.put(ERROR_DESC, (Object)exception.getSoleMessage());
    }

    public JSONObject write(FileStorageService service) throws JSONException {
        JSONArray jFormDescription;
        JSONObject serviceJSON = new JSONObject(6);
        serviceJSON.put("id", (Object)service.getId());
        serviceJSON.put("displayName", (Object)service.getDisplayName());
        DynamicFormDescription formDescription = service.getFormDescription();
        if (null != formDescription && (jFormDescription = new FormDescriptionWriter().write(formDescription)).length() > 0) {
            serviceJSON.put("configuration", (Object)jFormDescription);
        }
        return serviceJSON;
    }
}

