/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.json.FormContentParser;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.generic.DefaultFileStorageAccount;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import org.json.JSONException;
import org.json.JSONObject;

public class FileStorageAccountParser {
    private final FileStorageServiceRegistry registry;

    public FileStorageAccountParser(FileStorageServiceRegistry serviceRegistry) {
        this.registry = serviceRegistry;
    }

    public FileStorageAccount parse(JSONObject accountJSON) throws OXException, JSONException {
        DefaultFileStorageAccount account = new DefaultFileStorageAccount();
        account.setId(accountJSON.optString("id"));
        if (accountJSON.has("displayName")) {
            account.setDisplayName(accountJSON.optString("displayName"));
        }
        FileStorageService fsService = this.registry.getFileStorageService(accountJSON.getString("filestorageService"));
        account.setFileStorageService(fsService);
        if (accountJSON.has("configuration")) {
            account.setConfiguration(FormContentParser.parse((JSONObject)accountJSON.getJSONObject("configuration"), (DynamicFormDescription)fsService.getFormDescription()));
        }
        return account;
    }
}

