/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

public final class Quota {
    public static final int UNLIMITED = -1;
    private final long limit;
    private final long usage;
    private final Type type;

    public static Quota getUnlimitedQuota(Type type) {
        return type.getUnlimited();
    }

    public static Quota[] getUnlimitedQuotas(Type[] types) {
        Quota[] quotas = new Quota[types.length];
        for (int i = 0; i < quotas.length; ++i) {
            quotas[i] = types[i].getUnlimited();
        }
        return quotas;
    }

    public Quota(long limit, long usage, Type type) {
        this.limit = limit;
        this.usage = usage;
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (int)(this.usage ^ this.usage >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Quota)) {
            return false;
        }
        Quota other = (Quota)obj;
        if (this.limit != other.limit) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return this.usage == other.usage;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getUsage() {
        return this.usage;
    }

    public Type getType() {
        return this.type;
    }

    public long[] toLongArray() {
        return new long[]{this.limit, this.usage};
    }

    public String toString() {
        return "Quota [limit=" + this.limit + ", usage=" + this.usage + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum Type {
        STORAGE("STORAGE"),
        FILE("FILE");

        private final String typeStr;

        private Type(String typeStr) {
            this.typeStr = typeStr;
        }

        public String toString() {
            return this.typeStr;
        }

        public Quota getUnlimited() {
            return new Quota(-1L, -1L, this);
        }
    }
}

