/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.MediaFolderAwareFolderAccess;
import com.openexchange.file.storage.PermissionAware;
import com.openexchange.file.storage.Quota;
import com.openexchange.file.storage.infostore.folder.FolderParser;
import com.openexchange.file.storage.infostore.folder.FolderWriter;
import com.openexchange.file.storage.infostore.folder.ParsedFolder;
import com.openexchange.file.storage.infostore.osgi.Services;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.type.DocumentsType;
import com.openexchange.folderstorage.type.MusicType;
import com.openexchange.folderstorage.type.PicturesType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.TemplatesType;
import com.openexchange.folderstorage.type.TrashType;
import com.openexchange.folderstorage.type.VideosType;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;

public class InfostoreFolderAccess
implements FileStorageFolderAccess,
MediaFolderAwareFolderAccess,
PermissionAware {
    private static final String INFOSTORE_FOLDER_ID = String.valueOf(9);
    private static final String TREE_ID = "1";
    private final ServerSession session;
    private final InfostoreFacade infostore;

    public InfostoreFolderAccess(ServerSession session, InfostoreFacade infostore) {
        this.session = session;
        this.infostore = infostore;
    }

    public void clearFolder(String folderId) throws OXException {
        this.clearFolder(folderId, false);
    }

    public void clearFolder(String folderId, boolean hardDelete) throws OXException {
        this.getFolderService().clearFolder(TREE_ID, folderId, (Session)this.session);
    }

    public String createFolder(FileStorageFolder toCreate) throws OXException {
        return (String)this.getFolderService().createFolder(FolderParser.parseFolder(toCreate), (Session)this.session, this.initDecorator()).getResponse();
    }

    public String deleteFolder(String folderId) throws OXException {
        return this.deleteFolder(folderId, false);
    }

    public String deleteFolder(String folderId, boolean hardDelete) throws OXException {
        this.getFolderService().deleteFolder(TREE_ID, folderId, null, (Session)this.session, this.initDecorator().put("hardDelete", (Object)String.valueOf(hardDelete))).getResponse();
        return folderId;
    }

    public boolean exists(String folderId) throws OXException {
        try {
            this.getFolderService().getFolder(TREE_ID, folderId, (Session)this.session, this.initDecorator());
            return true;
        }
        catch (OXException e) {
            return false;
        }
    }

    public FileStorageFolder getFolder(String folderId) throws OXException {
        return FolderWriter.writeFolder(this.getFolderService().getFolder(TREE_ID, folderId, (Session)this.session, this.initDecorator()));
    }

    public FileStorageFolder getPersonalFolder() throws OXException {
        return this.getDefaultFolder((Type)PublicType.getInstance());
    }

    public FileStorageFolder getTrashFolder() throws OXException {
        return this.getDefaultFolder((Type)TrashType.getInstance());
    }

    public FileStorageFolder getPicturesFolder() throws OXException {
        return this.getDefaultFolder((Type)PicturesType.getInstance());
    }

    public FileStorageFolder getDocumentsFolder() throws OXException {
        return this.getDefaultFolder((Type)DocumentsType.getInstance());
    }

    public FileStorageFolder getTemplatesFolder() throws OXException {
        return this.getDefaultFolder((Type)TemplatesType.getInstance());
    }

    public FileStorageFolder getMusicFolder() throws OXException {
        return this.getDefaultFolder((Type)MusicType.getInstance());
    }

    public FileStorageFolder getVideosFolder() throws OXException {
        return this.getDefaultFolder((Type)VideosType.getInstance());
    }

    public FileStorageFolder[] getPublicFolders() throws OXException {
        UserizedFolder[] subfolders = (UserizedFolder[])this.getFolderService().getSubfolders(TREE_ID, "15", true, (Session)this.session, this.initDecorator()).getResponse();
        return FolderWriter.writeFolders(subfolders);
    }

    public FileStorageFolder[] getPath2DefaultFolder(String folderId) throws OXException {
        UserizedFolder[] folders = (UserizedFolder[])this.getFolderService().getPath(TREE_ID, folderId, (Session)this.session, this.initDecorator()).getResponse();
        return FolderWriter.writeFolders(folders);
    }

    public Quota getFileQuota(String folderId) throws OXException {
        return this.infostore.getFileQuota(this.session);
    }

    public Quota getStorageQuota(String folderId) throws OXException {
        return this.infostore.getStorageQuota(this.session);
    }

    public Quota[] getQuotas(String folder, Quota.Type[] types) throws OXException {
        if (null == types) {
            return null;
        }
        Quota[] quotas = new Quota[types.length];
        block4: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case FILE: {
                    quotas[i] = this.getFileQuota(folder);
                    continue block4;
                }
                case STORAGE: {
                    quotas[i] = this.getStorageQuota(folder);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("unknown type: " + types[i]);
                }
            }
        }
        return quotas;
    }

    public FileStorageFolder getRootFolder() throws OXException {
        try {
            return this.getFolder(INFOSTORE_FOLDER_ID);
        }
        catch (OXException e) {
            if (FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.equals(e)) {
                return null;
            }
            throw e;
        }
    }

    public FileStorageFolder[] getSubfolders(String parentIdentifier, boolean all) throws OXException {
        UserizedFolder[] subfolders = (UserizedFolder[])this.getFolderService().getSubfolders(TREE_ID, parentIdentifier, all, (Session)this.session, this.initDecorator()).getResponse();
        return FolderWriter.writeFolders(subfolders);
    }

    public FileStorageFolder[] getUserSharedFolders() throws OXException {
        UserizedFolder[] folders = (UserizedFolder[])this.getFolderService().getUserSharedFolders(TREE_ID, (ContentType)InfostoreContentType.getInstance(), (Session)this.session, this.initDecorator()).getResponse();
        return FolderWriter.writeFolders(folders);
    }

    public String moveFolder(String folderId, String newParentId) throws OXException {
        return this.moveFolder(folderId, newParentId, null);
    }

    public String moveFolder(String folderId, String newParentId, String newName) throws OXException {
        return this.moveFolder(folderId, newParentId, newName, null);
    }

    public String renameFolder(String folderId, String newName) throws OXException {
        return this.moveFolder(folderId, null, newName, null);
    }

    public String updateFolder(String identifier, FileStorageFolder toUpdate) throws OXException {
        Folder parsedFolder = FolderParser.parseFolder(toUpdate);
        parsedFolder.setID(identifier);
        this.getFolderService().updateFolder(parsedFolder, null, (Session)this.session, this.initDecorator()).getResponse();
        return null != parsedFolder.getNewID() ? parsedFolder.getNewID() : identifier;
    }

    private String moveFolder(String folderId, String newParentId, String newName, FolderServiceDecorator decorator) throws OXException {
        ParsedFolder folder = new ParsedFolder();
        folder.setTreeID(TREE_ID);
        folder.setID(folderId);
        if (null != newParentId) {
            folder.setParentID(newParentId);
        }
        if (null != newName) {
            folder.setName(newName);
        }
        this.getFolderService().updateFolder((Folder)folder, null, (Session)this.session, this.initDecorator());
        return null == folder.getNewID() ? folderId : folder.getNewID();
    }

    private FileStorageFolder getDefaultFolder(Type type) throws OXException {
        try {
            return FolderWriter.writeFolder(this.getFolderService().getDefaultFolder(this.session.getUser(), TREE_ID, (ContentType)InfostoreContentType.getInstance(), type, (Session)this.session, this.initDecorator()));
        }
        catch (OXException e) {
            if (FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.equals(e)) {
                throw FileStorageExceptionCodes.NO_SUCH_FOLDER.create((Throwable)e, new Object[0]);
            }
            throw e;
        }
    }

    private FolderService getFolderService() throws OXException {
        FolderService folderService = Services.getService(FolderService.class);
        if (null == folderService) {
            throw ServiceExceptionCode.absentService(FolderService.class);
        }
        return folderService;
    }

    private FolderServiceDecorator initDecorator() {
        FolderServiceDecorator decorator = new FolderServiceDecorator();
        Object connection = this.session.getParameter(Connection.class.getName());
        if (null != connection) {
            decorator.put(Connection.class.getName(), connection);
        }
        decorator.put("altNames", (Object)Boolean.TRUE.toString());
        decorator.setLocale(this.session.getUser().getLocale());
        return decorator;
    }
}

