/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.infostore.folder.UserizedFileStorageFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.UserizedFolder;
import java.util.ArrayList;

public final class FolderWriter {
    private FolderWriter() {
    }

    public static FileStorageFolder writeFolder(UserizedFolder folder) throws OXException {
        if (null == folder) {
            return null;
        }
        try {
            return new UserizedFileStorageFolder(folder);
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static FileStorageFolder[] writeFolders(UserizedFolder[] folders) throws OXException {
        return FolderWriter.writeFolders(folders, true);
    }

    public static FileStorageFolder[] writeFolders(UserizedFolder[] folders, boolean infostoreOnly) throws OXException {
        if (null == folders) {
            return null;
        }
        ArrayList<FileStorageFolder> fileStorageFolders = new ArrayList<FileStorageFolder>(folders.length);
        for (UserizedFolder folder : folders) {
            if (infostoreOnly && FolderWriter.isNotInfostore(folder)) continue;
            fileStorageFolders.add(FolderWriter.writeFolder(folder));
        }
        return fileStorageFolders.toArray(new FileStorageFolder[fileStorageFolders.size()]);
    }

    private static boolean isNotInfostore(UserizedFolder folder) {
        ContentType contentType;
        if (null != folder && null != (contentType = folder.getContentType())) {
            int module = contentType.getModule();
            if (8 == module || 14 == module) {
                return false;
            }
            if (5 == module) {
                try {
                    int numericalID = Integer.parseInt(folder.getID());
                    if (9 == numericalID || 10 == numericalID || 15 == numericalID) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return true;
    }
}

