/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageGuestPermission;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.infostore.folder.ParsedFolder;
import com.openexchange.file.storage.infostore.folder.ParsedGuestPermission;
import com.openexchange.file.storage.infostore.folder.ParsedPermission;
import com.openexchange.file.storage.infostore.osgi.Services;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.ContentTypeDiscoveryService;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.List;

public final class FolderParser {
    private static final String REAL_TREE_ID = FolderStorage.REAL_TREE_ID;
    private static final String INFOSTORE = "infostore";
    private static volatile ContentType contentType;

    private FolderParser() {
    }

    public static Folder parseFolder(FileStorageFolder fsFolder) throws OXException {
        if (null == fsFolder) {
            return null;
        }
        try {
            ParsedFolder folder = new ParsedFolder();
            folder.setTreeID(REAL_TREE_ID);
            String str = fsFolder.getId();
            if (!Strings.isEmpty((String)str)) {
                folder.setID(str);
            }
            if (!Strings.isEmpty((String)(str = fsFolder.getParentId()))) {
                folder.setParentID(str);
            }
            if (!Strings.isEmpty((String)(str = fsFolder.getName()))) {
                folder.setName(str);
            }
            folder.setContentType(FolderParser.getContentType());
            folder.setSubscribed(fsFolder.isSubscribed());
            List permissions = fsFolder.getPermissions();
            if (null != permissions && !permissions.isEmpty()) {
                folder.setPermissions(FolderParser.parsePermission(permissions));
            }
            folder.setMeta(fsFolder.getMeta());
            return folder;
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentType getContentType() throws OXException {
        ContentType ct = contentType;
        if (null != ct) return ct;
        Class<FolderParser> clazz = FolderParser.class;
        synchronized (FolderParser.class) {
            ct = contentType;
            if (null != ct) return ct;
            ContentTypeDiscoveryService discoveryService = Services.getService(ContentTypeDiscoveryService.class);
            ct = discoveryService.getByString(INFOSTORE);
            if (null == ct) {
                throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(new Object[]{INFOSTORE});
            }
            contentType = ct;
            return ct;
        }
    }

    private static Permission[] parsePermission(List<FileStoragePermission> fileStoragePermissions) throws OXException {
        if (null == fileStoragePermissions) {
            return null;
        }
        ArrayList<ParsedPermission> permissions = new ArrayList<ParsedPermission>(fileStoragePermissions.size());
        for (FileStoragePermission fileStoragePermission : fileStoragePermissions) {
            ParsedPermission permission;
            if (FileStorageGuestPermission.class.isInstance(fileStoragePermission)) {
                ParsedGuestPermission guestPermission = new ParsedGuestPermission();
                guestPermission.setRecipient(((FileStorageGuestPermission)fileStoragePermission).getRecipient());
                permission = guestPermission;
            } else {
                permission = new ParsedPermission();
            }
            permission.setEntity(fileStoragePermission.getEntity());
            permission.setGroup(fileStoragePermission.isGroup());
            permission.setAdmin(fileStoragePermission.isAdmin());
            permission.setAllPermissions(fileStoragePermission.getFolderPermission(), fileStoragePermission.getReadPermission(), fileStoragePermission.getWritePermission(), fileStoragePermission.getDeletePermission());
            permissions.add(permission);
        }
        return permissions.toArray(new Permission[fileStoragePermissions.size()]);
    }
}

