/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore;

import com.openexchange.file.storage.AbstractFile;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.UserizedFile;
import com.openexchange.file.storage.infostore.PermissionHelper;
import com.openexchange.groupware.infostore.DocumentMetadata;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InfostoreFile
extends AbstractFile
implements UserizedFile {
    private final DocumentMetadata document;

    public InfostoreFile(DocumentMetadata documentMetadata) {
        this.document = documentMetadata;
    }

    public String getCategories() {
        return this.document.getCategories();
    }

    public int getColorLabel() {
        return this.document.getColorLabel();
    }

    public String getContent() {
        return this.document.getContent();
    }

    public Date getCreated() {
        return this.document.getCreationDate();
    }

    public int getCreatedBy() {
        return this.document.getCreatedBy();
    }

    public String getDescription() {
        return this.document.getDescription();
    }

    public String getFileMD5Sum() {
        return this.document.getFileMD5Sum();
    }

    public String getFileMIMEType() {
        return this.document.getFileMIMEType();
    }

    public String getFileName() {
        return this.document.getFileName();
    }

    public long getFileSize() {
        return this.document.getFileSize();
    }

    public String getFolderId() {
        return Long.toString(this.document.getFolderId());
    }

    public String getId() {
        return Integer.toString(this.document.getId());
    }

    public Date getLastModified() {
        return this.document.getLastModified();
    }

    public Date getLockedUntil() {
        return this.document.getLockedUntil();
    }

    public int getModifiedBy() {
        return this.document.getModifiedBy();
    }

    public int getNumberOfVersions() {
        return this.document.getNumberOfVersions();
    }

    public String getProperty(String key) {
        return this.document.getProperty(key);
    }

    public Set<String> getPropertyNames() {
        return this.document.getPropertyNames();
    }

    public long getSequenceNumber() {
        return this.document.getSequenceNumber();
    }

    public String getTitle() {
        return this.document.getTitle();
    }

    public String getURL() {
        return this.document.getURL();
    }

    public String getVersion() {
        return Integer.toString(this.document.getVersion());
    }

    public String getVersionComment() {
        return this.document.getVersionComment();
    }

    public boolean isCurrentVersion() {
        return this.document.isCurrentVersion();
    }

    public void setCategories(String categories) {
        this.document.setCategories(categories);
    }

    public void setColorLabel(int color) {
        this.document.setColorLabel(color);
    }

    public void setCreatedBy(int cretor) {
        this.document.setCreatedBy(cretor);
    }

    public void setCreated(Date creationDate) {
        this.document.setCreationDate(creationDate);
    }

    public void setDescription(String description) {
        this.document.setDescription(description);
    }

    public void setFileMD5Sum(String sum) {
        this.document.setFileMD5Sum(sum);
    }

    public void setFileMIMEType(String type) {
        this.document.setFileMIMEType(type);
    }

    public void setFileName(String fileName) {
        this.document.setFileName(fileName);
    }

    public void setFileSize(long length) {
        this.document.setFileSize(length);
    }

    public void setFolderId(String folderId) {
        if (folderId != null) {
            this.document.setFolderId(Long.parseLong(folderId));
        }
    }

    public void setId(String id) {
        if (id == FileStorageFileAccess.NEW) {
            this.document.setId(-1);
        } else {
            this.document.setId(Integer.parseInt(id));
        }
    }

    public void setIsCurrentVersion(boolean bool) {
        this.document.setIsCurrentVersion(bool);
    }

    public void setLastModified(Date now) {
        this.document.setLastModified(now);
    }

    public void setLockedUntil(Date lockedUntil) {
        this.document.setLockedUntil(lockedUntil);
    }

    public void setModifiedBy(int lastEditor) {
        this.document.setModifiedBy(lastEditor);
    }

    public void setNumberOfVersions(int numberOfVersions) {
        this.document.setNumberOfVersions(numberOfVersions);
    }

    public void setTitle(String title) {
        this.document.setTitle(title);
    }

    public void setURL(String url) {
        this.document.setURL(url);
    }

    public void setVersion(String version) {
        this.document.setVersion(Integer.parseInt(version));
    }

    public void setVersionComment(String string) {
        this.document.setVersionComment(string);
    }

    public Map<String, Object> getMeta() {
        return this.document.getMeta();
    }

    public void setMeta(Map<String, Object> properties) {
        this.document.setMeta(properties);
    }

    public List<FileStorageObjectPermission> getObjectPermissions() {
        return PermissionHelper.getFileStorageObjectPermissions(this.document.getObjectPermissions());
    }

    public void setObjectPermissions(List<FileStorageObjectPermission> objectPermissions) {
        this.document.setObjectPermissions(PermissionHelper.getObjectPermissions(objectPermissions));
    }

    public boolean isShareable() {
        return this.document.isShareable();
    }

    public void setShareable(boolean shareable) {
        this.document.setShareable(shareable);
    }

    public String getOriginalId() {
        return Integer.toString(this.document.getOriginalId());
    }

    public void setOriginalId(String id) {
        this.document.setOriginalId(Integer.parseInt(id));
    }

    public String getOriginalFolderId() {
        return Long.toString(this.document.getOriginalFolderId());
    }

    public void setOriginalFolderId(String id) {
        this.document.setOriginalFolderId(Long.parseLong(id));
    }
}

