/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.FileHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class VersionContainer {
    private final Map<Integer, FileHolder> versions = new HashMap<Integer, FileHolder>();
    private int currentVersion = -1;

    public boolean containsVersion(int version) {
        return this.versions.containsKey(version);
    }

    public FileHolder getVersion(int version) {
        return this.versions.get(version);
    }

    public int addVersion(FileHolder fileHolder) {
        int version = ++this.currentVersion;
        this.versions.put(version, fileHolder);
        fileHolder.getInternalFile().setVersion("" + version);
        return version;
    }

    public FileHolder removeVersion(int version) {
        FileHolder removed = this.versions.remove(version);
        if (version == this.currentVersion) {
            int tmp = -1;
            for (int v : this.versions.keySet()) {
                if (v <= tmp) continue;
                tmp = v;
            }
            this.currentVersion = tmp;
        }
        return removed;
    }

    public FileHolder getCurrentVersion() {
        return this.versions.get(this.currentVersion);
    }

    public int getCurrentVersionNumber() {
        return this.currentVersion;
    }

    public Collection<FileHolder> getAllVersions() {
        return this.versions.values();
    }
}

