/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class FileHolder {
    private final File file;
    private final byte[] content;

    public FileHolder(File file) {
        this.file = new DefaultFile(file);
        this.content = null;
    }

    public FileHolder(File file, byte[] content) {
        this.file = new DefaultFile(file);
        this.content = content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileHolder(File file, InputStream content) {
        byte[] tmp;
        this.file = new DefaultFile(file);
        try {
            tmp = IOUtils.toByteArray((InputStream)content);
        }
        catch (IOException e) {
            tmp = new byte[]{};
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
        this.content = tmp;
    }

    public File getFile() {
        return new DefaultFile(this.file);
    }

    public File getInternalFile() {
        return this.file;
    }

    public InputStream getContent() {
        if (this.content == null) {
            return null;
        }
        return new ByteArrayInputStream(this.content);
    }
}

