/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.datatypes.genericonf.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.datatypes.genericonf.json.FormDescriptionWriter;
import com.openexchange.i18n.Translator;
import com.openexchange.json.JSONAssertion;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FormDescriptionWriterTest
extends TestCase {
    private DynamicFormDescription form;
    private final TestTranslator translator = new TestTranslator();

    public void setUp() throws Exception {
        this.form = new DynamicFormDescription();
    }

    public void testWriteElement() throws JSONException {
        FormElement element = new FormElement();
        element.setWidget(FormElement.Widget.INPUT);
        element.setDisplayName("Login name");
        element.setName("login");
        element.setMandatory(true);
        element.setDefaultValue((Object)"admin");
        JSONObject object = new FormDescriptionWriter((Translator)this.translator).write(element);
        JSONAssertion assertion = new JSONAssertion().isObject().hasKey("widget").withValue((Object)"input").hasKey("name").withValue((Object)"login").hasKey("displayName").withValue((Object)"Login name").hasKey("mandatory").withValue((Object)true).hasKey("defaultValue").withValue((Object)"admin").objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
        element.setWidget(FormElement.Widget.PASSWORD);
        element.setDisplayName("Password");
        element.setName("password");
        element.setMandatory(false);
        element.setDefaultValue(null);
        object = new FormDescriptionWriter((Translator)this.translator).write(element);
        assertion = new JSONAssertion().isObject().hasKey("widget").withValue((Object)"password").hasKey("name").withValue((Object)"password").hasKey("displayName").withValue((Object)"Password").hasKey("mandatory").withValue((Object)false).objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
        element.setWidget(FormElement.Widget.CHECKBOX);
        element.setDisplayName("Checkbox");
        element.setName("checkbox");
        object = new FormDescriptionWriter((Translator)this.translator).write(element);
        assertion = new JSONAssertion().isObject().hasKey("widget").withValue((Object)"checkbox").hasKey("name").withValue((Object)"checkbox").hasKey("displayName").withValue((Object)"Checkbox").hasKey("mandatory").withValue((Object)false).objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
    }

    public void testWriteArray() throws JSONException {
        FormElement element = new FormElement();
        element.setWidget(FormElement.Widget.INPUT);
        element.setDisplayName("Login name");
        element.setName("login");
        element.setMandatory(true);
        element.setDefaultValue((Object)"admin");
        this.form.add(element);
        JSONArray array = new FormDescriptionWriter((Translator)this.translator).write(this.form);
        FormDescriptionWriterTest.assertEquals((int)1, (int)array.length());
        JSONAssertion assertion = new JSONAssertion().isObject().hasKey("widget").withValue((Object)"input").hasKey("name").withValue((Object)"login").hasKey("displayName").withValue((Object)"Login name").hasKey("mandatory").withValue((Object)true).hasKey("defaultValue").withValue((Object)"admin").objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)array.getJSONObject(0));
    }

    public void testCustom() throws JSONException {
        FormElement element = new FormElement();
        element.setWidget(FormElement.Widget.CUSTOM);
        element.setDisplayName("Thingamajick");
        element.setName("thingamajick");
        element.setMandatory(true);
        element.setDefaultValue((Object)"admin");
        element.setCustomWidget("com.openexchange.test.thingamajickChooser");
        JSONObject object = new FormDescriptionWriter((Translator)this.translator).write(element);
        JSONAssertion assertion = new JSONAssertion().isObject().hasKey("widget").withValue((Object)"com.openexchange.test.thingamajickChooser").hasKey("name").withValue((Object)"thingamajick").hasKey("displayName").withValue((Object)"Thingamajick").hasKey("mandatory").withValue((Object)true).hasKey("defaultValue").withValue((Object)"admin").objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
    }

    public void testOptions() throws JSONException {
        FormElement element = new FormElement();
        element.setWidget(FormElement.Widget.INPUT);
        element.setDisplayName("Login name");
        element.setName("login");
        element.setMandatory(true);
        element.setDefaultValue((Object)"admin");
        element.setOption("someOption", "12").setOption("someOtherOption", "23");
        JSONObject object = new FormDescriptionWriter((Translator)this.translator).write(element);
        JSONAssertion assertion = new JSONAssertion().isObject().hasKey("widget").withValue((Object)"input").hasKey("name").withValue((Object)"login").hasKey("displayName").withValue((Object)"Login name").hasKey("mandatory").withValue((Object)true).hasKey("defaultValue").withValue((Object)"admin").hasKey("options").withValueObject().hasKey("someOption").withValue((Object)"12").hasKey("someOtherOption").withValue((Object)"23").objectEnds().objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
    }

    private static final class TestTranslator
    implements Translator {
        private TestTranslator() {
        }

        public String translate(String toTranslate) {
            return toTranslate;
        }
    }
}

