/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config;

import com.openexchange.config.PropertyFilter;
import com.openexchange.exception.OXException;
import java.util.regex.Pattern;

public class WildcardNamePropertyFilter
implements PropertyFilter {
    private final Pattern pattern;

    public WildcardNamePropertyFilter(String wildcard) {
        this.pattern = WildcardNamePropertyFilter.isEmpty(wildcard) ? null : Pattern.compile(WildcardNamePropertyFilter.wildcardToRegex(wildcard));
    }

    @Override
    public boolean accept(String name, String value) throws OXException {
        return null == this.pattern ? true : this.pattern.matcher(name).matches();
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }
}

