/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.osgi;

import com.openexchange.management.ManagementService;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessionCount.SessionThreadCountMBeanImpl;
import com.openexchange.sessiond.SessiondService;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagementServiceTrackerCustomizer2
implements ServiceTrackerCustomizer<ManagementService, ManagementService> {
    private final BundleContext context;
    private final SessionThreadCounter counter;
    private final ServiceTracker<SessiondService, SessiondService> sessiondServiceTracker;
    private ObjectName objectName;

    public ManagementServiceTrackerCustomizer2(BundleContext context, SessionThreadCounter counter, ServiceTracker<SessiondService, SessiondService> sessiondServiceTracker) {
        this.context = context;
        this.counter = counter;
        this.sessiondServiceTracker = sessiondServiceTracker;
    }

    public ManagementService addingService(ServiceReference<ManagementService> reference) {
        ManagementService service = (ManagementService)this.context.getService(reference);
        this.registerCacheMBean(service);
        return service;
    }

    public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
        if (null != service && ManagementService.class.isInstance(service)) {
            try {
                this.unregisterCacheMBean(service);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }

    void registerCacheMBean(ManagementService management) {
        if (this.objectName == null) {
            Logger LOG = LoggerFactory.getLogger(ManagementServiceTrackerCustomizer2.class);
            try {
                this.objectName = ManagementServiceTrackerCustomizer2.getObjectName(SessionThreadCountMBeanImpl.class.getName(), "com.openexchange.sessionCount");
                management.registerMBean(this.objectName, (Object)new SessionThreadCountMBeanImpl(this.counter, this.sessiondServiceTracker));
            }
            catch (MalformedObjectNameException e) {
                LOG.error("", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                LOG.error("", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterCacheMBean(ManagementService management) {
        if (this.objectName != null) {
            try {
                management.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ManagementServiceTrackerCustomizer2.class).error("", (Throwable)e);
            }
            finally {
                this.objectName = null;
            }
        }
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

