/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.threadpool.CompletionFuture;
import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.CustomFutureTask;
import com.openexchange.threadpool.internal.CustomThreadFactory;
import com.openexchange.threadpool.internal.CustomThreadPoolExecutor;
import com.openexchange.threadpool.internal.DelegateExecutorService;
import com.openexchange.threadpool.internal.DelegatingRejectedExecutionHandler;
import com.openexchange.threadpool.internal.FixedExecutorService;
import com.openexchange.threadpool.internal.QueueType;
import com.openexchange.threadpool.internal.RejectedExecutionType;
import com.openexchange.threadpool.internal.ScalingQueue;
import com.openexchange.threadpool.internal.ThreadPoolProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class ThreadPoolServiceImpl
implements ThreadPoolService {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolServiceImpl.class);
    private final CustomThreadPoolExecutor threadPoolExecutor;
    private final int corePoolSize;

    public static ThreadPoolServiceImpl newInstance(ThreadPoolProperties properties) {
        return ThreadPoolServiceImpl.newInstance(properties.getCorePoolSize(), properties.getMaximumPoolSize(), properties.getKeepAliveTime(), properties.getWorkQueue(), properties.getWorkQueueSize(), properties.isBlocking(), properties.getRefusedExecutionBehavior());
    }

    public static ThreadPoolServiceImpl newInstance(int corePoolSize, int maximumPoolSize, long keepAliveTime, String workQueue, int workQueueSize, boolean blocking, String refusedExecutionBehavior) {
        return new ThreadPoolServiceImpl(corePoolSize, maximumPoolSize, keepAliveTime, workQueue, workQueueSize, blocking, refusedExecutionBehavior);
    }

    private ThreadPoolServiceImpl(int corePoolSize, int maximumPoolSize, long keepAliveTime, String workQueue, int workQueueSize, boolean blocking, String refusedExecutionBehavior) {
        QueueType queueType = QueueType.getQueueType(workQueue);
        if (null == queueType) {
            throw new IllegalArgumentException("Unknown queue type: " + workQueue);
        }
        RejectedExecutionType ret = RejectedExecutionType.getRejectedExecutionType(refusedExecutionBehavior);
        if (null == ret) {
            throw new IllegalArgumentException("Unknown refused execution behavior: " + refusedExecutionBehavior);
        }
        this.corePoolSize = ThreadPoolServiceImpl.getCorePoolSize(corePoolSize);
        if (QueueType.LINKED.equals((Object)queueType) && corePoolSize < maximumPoolSize) {
            ScalingQueue scalingQueue = workQueueSize > 0 ? new ScalingQueue(workQueueSize) : new ScalingQueue();
            this.threadPoolExecutor = new CustomThreadPoolExecutor(this.corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)scalingQueue, new CustomThreadFactory("OXWorker-"));
            scalingQueue.setThreadPoolExecutor(this.threadPoolExecutor);
            scalingQueue.setThreadPool(this);
            DelegatingRejectedExecutionHandler reh = new DelegatingRejectedExecutionHandler(ret.getHandler(), this);
            this.threadPoolExecutor.setRejectedExecutionHandler(scalingQueue.createRejectedExecutionHandler(reh));
            this.threadPoolExecutor.setBlocking(false);
        } else {
            this.threadPoolExecutor = new CustomThreadPoolExecutor(queueType.isFixedSize() ? maximumPoolSize : this.corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, queueType.newWorkQueue(workQueueSize), new CustomThreadFactory("OXWorker-"));
            DelegatingRejectedExecutionHandler reh = new DelegatingRejectedExecutionHandler(ret.getHandler(), this);
            this.threadPoolExecutor.setRejectedExecutionHandler(reh);
            this.threadPoolExecutor.setBlocking(blocking);
        }
    }

    private static int getCorePoolSize(int desiredCorePoolSize) {
        int minCorePoolSize = Runtime.getRuntime().availableProcessors() + 1;
        if (desiredCorePoolSize < minCorePoolSize) {
            LOG.warn("\n\n\tConfigured pool size of {} through property \"com.openexchange.threadpool.corePoolSize\" does not obey the rule\n\tfor minimum core pool size: {} (number of CPUs) + 1 = {}. Using {} as core pool size.\n", new Object[]{desiredCorePoolSize, Runtime.getRuntime().availableProcessors(), minCorePoolSize, minCorePoolSize});
            return minCorePoolSize;
        }
        return desiredCorePoolSize;
    }

    public boolean awaitTermination(long timeout) throws InterruptedException {
        return this.threadPoolExecutor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.threadPoolExecutor.shutdown();
    }

    public void prestartAllCoreThreads() {
        this.threadPoolExecutor.prestartAllCoreThreads();
    }

    public List<Runnable> shutdownNow() {
        return this.threadPoolExecutor.shutdownNow();
    }

    @Override
    public int getActiveCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }

    @Override
    public int getLargestPoolSize() {
        return this.threadPoolExecutor.getLargestPoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    @Override
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Task<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            Map mdcMap = MDC.getCopyOfContextMap();
            for (Task<T> task : tasks) {
                CustomFutureTask<T> ftask = new CustomFutureTask<T>(task, mdcMap);
                futures.add(ftask);
                this.threadPoolExecutor.execute(ftask);
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                    LOG.debug("", (Throwable)cancellationException);
                }
                catch (ExecutionException executionException) {
                    LOG.debug("", (Throwable)executionException);
                }
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Task<T>> tasks, long timeout) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        long nanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            Map mdcMap = MDC.getCopyOfContextMap();
            for (Task<T> t : tasks) {
                futures.add(new CustomFutureTask<T>(t, mdcMap));
            }
            long lastTime = System.nanoTime();
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                this.threadPoolExecutor.execute((Runnable)it.next());
                long now = System.nanoTime();
                lastTime = now;
                if ((nanos -= now - lastTime) > 0L) continue;
                ArrayList<Future<T>> arrayList = futures;
                return arrayList;
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                if (nanos <= 0L) {
                    ArrayList<Future<T>> arrayList = futures;
                    return arrayList;
                }
                try {
                    future.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException ignore) {
                    LOG.debug("", (Throwable)ignore);
                }
                catch (ExecutionException ignore) {
                    LOG.debug("", (Throwable)ignore);
                }
                catch (TimeoutException toe) {
                    ArrayList<Future<T>> arrayList = futures;
                    if (!done) {
                        for (Future future2 : futures) {
                            future2.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long now = System.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    @Override
    public <T> CompletionFuture<T> invoke(Collection<? extends Task<T>> tasks) {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ExecutorCompletionService<T> completionService = new ExecutorCompletionService<T>(this.threadPoolExecutor);
        for (Task<T> task : tasks) {
            completionService.submit(task);
        }
        return new CompletionFutureImpl(completionService);
    }

    @Override
    public <T> CompletionFuture<T> invoke(Task<T>[] tasks) {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ExecutorCompletionService<T> completionService = new ExecutorCompletionService<T>(this.threadPoolExecutor);
        for (Task<T> task : tasks) {
            completionService.submit(task);
        }
        return new CompletionFutureImpl(completionService);
    }

    @Override
    public <T> CompletionFuture<T> invoke(Collection<? extends Task<T>> tasks, RefusedExecutionBehavior<T> behavior) {
        if (tasks == null) {
            throw new NullPointerException();
        }
        Map mdcMap = MDC.getCopyOfContextMap();
        CustomExecutorCompletionService<T> completionService = new CustomExecutorCompletionService<T>(this.threadPoolExecutor, behavior, mdcMap);
        for (Task<T> task : tasks) {
            completionService.submit(task);
        }
        return new CompletionFutureImpl(completionService);
    }

    public CustomThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    @Override
    public ExecutorService getExecutor() {
        return new DelegateExecutorService(this.threadPoolExecutor);
    }

    @Override
    public ExecutorService getFixedExecutor() {
        return new FixedExecutorService(this.corePoolSize, this.threadPoolExecutor);
    }

    @Override
    public ExecutorService getFixedExecutor(int size) {
        return new FixedExecutorService(size, this.threadPoolExecutor);
    }

    @Override
    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.threadPoolExecutor.isTerminated();
    }

    @Override
    public <T> Future<T> submit(Task<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Map mdcMap = MDC.getCopyOfContextMap();
        CustomFutureTask<T> ftask = new CustomFutureTask<T>(task, mdcMap);
        this.threadPoolExecutor.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Task<T> task, RefusedExecutionBehavior<T> refusedExecutionBehavior) {
        if (task == null) {
            throw new NullPointerException();
        }
        Map mdcMap = MDC.getCopyOfContextMap();
        CustomFutureTask<T> ftask = new CustomFutureTask<T>(task, refusedExecutionBehavior, mdcMap);
        this.threadPoolExecutor.execute(ftask);
        return ftask;
    }

    private static final class CompletionFutureImpl<V>
    implements CompletionFuture<V> {
        private final CompletionService<V> completionService;

        public CompletionFutureImpl(CompletionService<V> completionService) {
            this.completionService = completionService;
        }

        @Override
        public Future<V> poll() {
            return this.completionService.poll();
        }

        @Override
        public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.completionService.poll(timeout, unit);
        }

        @Override
        public Future<V> take() throws InterruptedException {
            return this.completionService.take();
        }
    }

    private static final class CustomExecutorCompletionService<V>
    implements CompletionService<V> {
        private final Executor executor;
        private final RefusedExecutionBehavior behavior;
        private final BlockingQueue<Future<V>> completionQueue;
        private final Map<String, Object> mdcMap;

        public CustomExecutorCompletionService(Executor executor, RefusedExecutionBehavior behavior, Map<String, Object> mdcMap) {
            if (executor == null) {
                throw new NullPointerException();
            }
            this.mdcMap = mdcMap;
            this.behavior = behavior;
            this.executor = executor;
            this.completionQueue = new LinkedBlockingQueue<Future<V>>();
        }

        @Override
        public Future<V> submit(Callable<V> task) {
            if (task == null) {
                throw new NullPointerException();
            }
            CustomQueueingFuture f = new CustomQueueingFuture((Task)task, this.mdcMap);
            this.executor.execute(f);
            return f;
        }

        @Override
        public Future<V> submit(Runnable task, V result) {
            throw new UnsupportedOperationException("ThreadPoolServiceImpl.CustomExecutorCompletionService.submit()");
        }

        @Override
        public Future<V> take() throws InterruptedException {
            return this.completionQueue.take();
        }

        @Override
        public Future<V> poll() {
            return (Future)this.completionQueue.poll();
        }

        @Override
        public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.completionQueue.poll(timeout, unit);
        }

        private class CustomQueueingFuture
        extends CustomFutureTask<V> {
            CustomQueueingFuture(Task<V> task, Map<String, Object> mdcMap) {
                super(task, CustomExecutorCompletionService.this.behavior, mdcMap);
            }

            @Override
            protected void done() {
                CustomExecutorCompletionService.this.completionQueue.add(this);
            }
        }
    }
}

