/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

public final class BoundedExecutor {
    private final Executor executor;
    private final Semaphore semaphore;

    public BoundedExecutor(Executor executor, int bound) {
        this.executor = executor;
        this.semaphore = new Semaphore(bound);
    }

    public void submitTask(Runnable command) throws InterruptedException {
        if (null == command) {
            return;
        }
        Semaphore semaphore = this.semaphore;
        semaphore.acquire();
        try {
            this.executor.execute(new SemaphoredRunnable(semaphore, command));
        }
        catch (RejectedExecutionException e) {
            semaphore.release();
            throw e;
        }
    }

    private static final class SemaphoredRunnable
    implements Runnable {
        private final Semaphore semaphore;
        private final Runnable command;

        SemaphoredRunnable(Semaphore semaphore, Runnable command) {
            this.semaphore = semaphore;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.command.run();
            }
            finally {
                this.semaphore.release();
            }
        }
    }
}

