/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.processing.internal;

import com.openexchange.processing.internal.ProcessorThreadFactory;
import com.openexchange.processing.internal.RoundRobinProcessor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorThreadPoolExecutor.class);

    public ProcessorThreadPoolExecutor(String name, int nThreads) {
        super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ProcessorThreadFactory(name));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null && r instanceof RoundRobinProcessor.Selector) {
            LOG.info("Processor thread '{}' terminated abruptly.", (Object)Thread.currentThread().getName(), (Object)t);
        }
    }
}

