/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.processing.internal;

import com.openexchange.exception.OXException;
import com.openexchange.processing.Processor;
import com.openexchange.processing.ProcessorService;
import com.openexchange.processing.internal.BoundedRoundRobinProcessor;
import com.openexchange.processing.internal.RoundRobinProcessor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessorServiceImpl
implements ProcessorService {
    private final AtomicInteger count = new AtomicInteger();
    private final Queue<Processor> processors = new ConcurrentLinkedQueue<Processor>();

    @Override
    public Processor newProcessor(String name, int numThreads) throws OXException {
        try {
            int id = this.count.incrementAndGet();
            RoundRobinProcessor processor = new RoundRobinProcessor(null == name ? "Processor" + id : name, numThreads);
            this.processors.offer(processor);
            return processor;
        }
        catch (RuntimeException e) {
            throw OXException.general((String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Processor newBoundedProcessor(String name, int numThreads, int maxTasks) throws OXException {
        try {
            int id = this.count.incrementAndGet();
            BoundedRoundRobinProcessor processor = new BoundedRoundRobinProcessor(null == name ? "Processor" + id : name, numThreads, maxTasks);
            this.processors.offer(processor);
            return processor;
        }
        catch (RuntimeException e) {
            throw OXException.general((String)e.getMessage(), (Throwable)e);
        }
    }

    public void shutDownAll() {
        Processor processor;
        while ((processor = this.processors.poll()) != null) {
            processor.stop();
        }
    }
}

