/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.osgi;

import com.openexchange.context.ContextService;
import com.openexchange.context.osgi.WhiteboardContextService;
import com.openexchange.crypto.CryptoService;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.datatypes.genericonf.storage.osgi.tools.WhiteboardGenericConfigurationStorageService;
import com.openexchange.folder.FolderService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.generic.FolderUpdaterRegistry;
import com.openexchange.groupware.generic.FolderUpdaterService;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.recovery.EncryptedItemCleanUpService;
import com.openexchange.secret.recovery.EncryptedItemDetectorService;
import com.openexchange.secret.recovery.SecretMigrator;
import com.openexchange.subscribe.AbstractSubscribeService;
import com.openexchange.subscribe.SubscriptionExecutionService;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.database.SubscriptionUserDeleteListener;
import com.openexchange.subscribe.helpers.DocumentMetadataHolder;
import com.openexchange.subscribe.internal.CalendarFolderUpdaterStrategy;
import com.openexchange.subscribe.internal.ContactFolderMultipleUpdaterStrategy;
import com.openexchange.subscribe.internal.ContactFolderUpdaterStrategy;
import com.openexchange.subscribe.internal.DocumentMetadataHolderFolderUpdaterStrategy;
import com.openexchange.subscribe.internal.StrategyFolderUpdaterService;
import com.openexchange.subscribe.internal.SubscriptionExecutionServiceImpl;
import com.openexchange.subscribe.internal.TaskFolderUpdaterStrategy;
import com.openexchange.subscribe.osgi.AutoUpdateActivator;
import com.openexchange.subscribe.osgi.OSGiSubscriptionSourceCollector;
import com.openexchange.subscribe.osgi.OSGiSubscriptionSourceDiscoveryCollector;
import com.openexchange.subscribe.secret.SubscriptionSecretHandling;
import com.openexchange.subscribe.sql.SubscriptionSQLStorage;
import com.openexchange.user.UserService;
import com.openexchange.userconf.UserPermissionService;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;

public class DiscoveryActivator
extends HousekeepingActivator {
    private volatile OSGiSubscriptionSourceCollector collector;
    private volatile WhiteboardContextService contextService;
    private volatile WhiteboardGenericConfigurationStorageService genconfStorage;

    public void startBundle() throws Exception {
        WhiteboardGenericConfigurationStorageService genconfStorage;
        WhiteboardContextService contextService;
        OSGiSubscriptionSourceCollector collector;
        this.collector = collector = new OSGiSubscriptionSourceCollector(this.context);
        this.contextService = contextService = new WhiteboardContextService(this.context);
        UserService users = (UserService)this.getService(UserService.class);
        UserPermissionService userPermissions = (UserPermissionService)this.getService(UserPermissionService.class);
        InfostoreFacade infostore = (InfostoreFacade)this.getService(InfostoreFacade.class);
        FolderService folders = (FolderService)this.getService(FolderService.class);
        Hashtable<String, Integer> discoveryDict = new Hashtable<String, Integer>();
        ((Dictionary)discoveryDict).put("service.ranking", 256);
        OSGiSubscriptionSourceDiscoveryCollector discoveryCollector = new OSGiSubscriptionSourceDiscoveryCollector(this.context);
        discoveryCollector.addSubscriptionSourceDiscoveryService(collector);
        AutoUpdateActivator.COLLECTOR = discoveryCollector;
        this.registerService(SubscriptionSourceDiscoveryService.class, discoveryCollector, discoveryDict);
        ArrayList folderUpdaters = new ArrayList(5);
        folderUpdaters.add((FolderUpdaterService<?>)new StrategyFolderUpdaterService<Contact>(new ContactFolderUpdaterStrategy()));
        folderUpdaters.add((FolderUpdaterService<?>)new StrategyFolderUpdaterService<Contact>(new ContactFolderMultipleUpdaterStrategy(), true));
        folderUpdaters.add((FolderUpdaterService<?>)new StrategyFolderUpdaterService<CalendarDataObject>(new CalendarFolderUpdaterStrategy()));
        folderUpdaters.add((FolderUpdaterService<?>)new StrategyFolderUpdaterService<Task>(new TaskFolderUpdaterStrategy()));
        folderUpdaters.add((FolderUpdaterService<?>)new StrategyFolderUpdaterService<DocumentMetadataHolder>(new DocumentMetadataHolderFolderUpdaterStrategy(users, userPermissions, infostore)));
        SubscriptionExecutionServiceImpl executor = new SubscriptionExecutionServiceImpl(collector, folderUpdaters, (ContextService)contextService);
        this.registerService(SubscriptionExecutionService.class, executor);
        this.registerService(FolderUpdaterRegistry.class, executor);
        AutoUpdateActivator.EXECUTOR = executor;
        DBProvider provider = (DBProvider)this.getService(DBProvider.class);
        this.genconfStorage = genconfStorage = new WhiteboardGenericConfigurationStorageService(this.context);
        SubscriptionSQLStorage storage = new SubscriptionSQLStorage(provider, (GenericConfigurationStorageService)genconfStorage, discoveryCollector);
        AbstractSubscribeService.STORAGE.set(storage);
        AbstractSubscribeService.ENCRYPTION_FACTORY.set((SecretEncryptionFactoryService)this.getService(SecretEncryptionFactoryService.class));
        AbstractSubscribeService.CRYPTO_SERVICE.set((CryptoService)this.getService(CryptoService.class));
        AbstractSubscribeService.FOLDERS.set(folders);
        AbstractSubscribeService.USER_PERMISSIONS.set(userPermissions);
        SubscriptionUserDeleteListener listener = new SubscriptionUserDeleteListener();
        listener.setStorageService((GenericConfigurationStorageService)genconfStorage);
        listener.setDiscoveryService(discoveryCollector);
        this.registerService(DeleteListener.class, listener);
        SubscriptionSecretHandling secretHandling = new SubscriptionSecretHandling(discoveryCollector);
        this.registerService(EncryptedItemDetectorService.class, secretHandling);
        this.registerService(EncryptedItemCleanUpService.class, secretHandling);
        this.registerService(SecretMigrator.class, secretHandling);
    }

    public void stopBundle() throws Exception {
        WhiteboardContextService contextService;
        OSGiSubscriptionSourceCollector collector;
        WhiteboardGenericConfigurationStorageService genconfStorage = this.genconfStorage;
        if (null != genconfStorage) {
            genconfStorage.close();
            this.genconfStorage = null;
        }
        if (null != (collector = this.collector)) {
            collector.close();
            this.collector = null;
        }
        if (null != (contextService = this.contextService)) {
            contextService.close();
            this.contextService = null;
        }
        this.unregisterServices();
        AbstractSubscribeService.STORAGE.set(null);
        AbstractSubscribeService.ENCRYPTION_FACTORY.set(null);
        AbstractSubscribeService.CRYPTO_SERVICE.set(null);
        AbstractSubscribeService.FOLDERS.set(null);
        AbstractSubscribeService.USER_PERMISSIONS.set(null);
    }

    protected Class<?>[] getNeededServices() {
        return new Class[]{UserService.class, UserPermissionService.class, InfostoreFacade.class, FolderService.class, DBProvider.class, SecretEncryptionFactoryService.class, CryptoService.class};
    }
}

