/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.context.ContextService;
import com.openexchange.context.SimContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.SimContext;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.subscribe.SimFolderUpdaterService;
import com.openexchange.subscribe.SimSubscribeService;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.internal.SubscriptionExecutionServiceImpl;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SimServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class SubscriptionExecutionServiceImplTest
extends TestCase {
    private static final String SOURCE_NAME = "com.openexchange.subscribe.test1";
    private static final String SOURCE_NAME2 = "com.openexchange.subscribe.test2";
    private SubscriptionExecutionServiceImpl executionService;
    private final SimSubscriptionSourceDiscoveryService discovery = new SimSubscriptionSourceDiscoveryService();
    private SimSubscribeService subscribeService;
    private SimFolderUpdaterService simFolderUpdaterService;
    private Subscription subscription;

    protected void setUp() throws Exception {
        super.setUp();
        SubscriptionSource source = new SubscriptionSource();
        source.setId(SOURCE_NAME);
        this.subscribeService = new SimSubscribeService();
        this.subscription = new Subscription();
        this.subscription.setContext((Context)new SimContext(2));
        this.subscription.setId(12);
        this.subscription.setFolderId("12");
        this.subscribeService.setSubscription(this.subscription);
        this.subscribeService.setContent(Arrays.asList("entry1", "entry2", "entry3"));
        source.setSubscribeService((SubscribeService)this.subscribeService);
        this.subscribeService.setSubscriptionSource(source);
        SubscriptionSource source2 = new SubscriptionSource();
        source2.setId(SOURCE_NAME2);
        source2.setSubscribeService((SubscribeService)new SimSubscribeService());
        this.discovery.addSource(source);
        this.discovery.addSource(source2);
        this.discovery.setLookupIdentifier(source.getId());
        this.simFolderUpdaterService = new SimFolderUpdaterService();
        this.simFolderUpdaterService.setHandles(true);
        ArrayList<SimFolderUpdaterService> list = new ArrayList<SimFolderUpdaterService>(1);
        list.add(this.simFolderUpdaterService);
        this.executionService = new SubscriptionExecutionServiceImpl(this.discovery, list, (ContextService)new SimContextService()){

            protected FolderObject getFolder(TargetFolderSession subscriptionSession, int contextId, int folderId) throws OXException {
                return null;
            }
        };
    }

    public void testShouldTransferDataCorrectly() throws OXException {
        this.executionService.executeSubscription(SOURCE_NAME, this.sessionForContext(new SimContext(2)), 12);
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong source used", (String)SOURCE_NAME, (String)this.discovery.getLoadedSources().get(0));
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong context", (int)2, (int)this.subscribeService.getSubscriptionIDs().get(0).getContext().getContextId());
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong id", (int)12, (int)this.subscribeService.getSubscriptionIDs().get(0).getId());
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong data saved", Arrays.asList("entry1", "entry2", "entry3"), (Object)this.simFolderUpdaterService.getData());
    }

    private ServerSession sessionForContext(SimContext simContext) {
        return new SimServerSession((Context)simContext, null, null);
    }

    public void testShouldNotThrowNPEWhenNoFolderUpdaterIsFound() {
        SubscriptionExecutionServiceImplTest.assertTrue((boolean)true);
    }

    public void testShouldGuessCorrectSubscriptionSource() throws OXException {
        this.executionService.executeSubscription(this.sessionForContext(new SimContext(2)), 12);
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong source used", (String)SOURCE_NAME, (String)this.discovery.getLoadedSources().get(0));
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong context", (int)2, (int)this.subscribeService.getSubscriptionIDs().get(0).getContext().getContextId());
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong id", (int)12, (int)this.subscribeService.getSubscriptionIDs().get(0).getId());
        SubscriptionExecutionServiceImplTest.assertEquals((String)"Wrong data saved", Arrays.asList("entry1", "entry2", "entry3"), (Object)this.simFolderUpdaterService.getData());
    }

    public void testShouldNotThrowNPEWhenNoSubscriptionSourceIsFound() {
        SubscriptionExecutionServiceImplTest.assertTrue((boolean)true);
    }

    public void testShouldReturnSingleUpdaterIfItIsTheOnlyOnePresent() throws OXException {
        SubscriptionExecutionServiceImplTest.assertEquals((String)"The first Updater should be returned", (Object)this.simFolderUpdaterService, (Object)this.executionService.getFolderUpdater((TargetFolderDefinition)this.subscription));
    }

    public void testShouldReturnSingleUpdaterIfThereIsOnlyOneSubscriptionOnTheFolder() throws OXException {
        SimFolderUpdaterService simFolderUpdaterService2 = new SimFolderUpdaterService();
        simFolderUpdaterService2.setHandles(true);
        simFolderUpdaterService2.setUsesMultipleStrategy(false);
        ArrayList<SimFolderUpdaterService> list = new ArrayList<SimFolderUpdaterService>(2);
        list.add(this.simFolderUpdaterService);
        list.add(simFolderUpdaterService2);
        this.executionService = new SubscriptionExecutionServiceImpl(this.discovery, list, (ContextService)new SimContextService()){

            protected FolderObject getFolder(TargetFolderSession subscriptionSession, int contextId, int folderId) throws OXException {
                return null;
            }
        };
        SubscriptionExecutionServiceImplTest.assertEquals((String)"The first Updater should be returned", (Object)this.simFolderUpdaterService, (Object)this.executionService.getFolderUpdater((TargetFolderDefinition)this.subscription));
    }

    public void testShouldReturnMultipleUpdaterIfThereAreTwoSubscriptionsOnTheFolder() throws OXException {
        Subscription subscription2 = new Subscription();
        this.subscription.setContext((Context)new SimContext(2));
        this.subscription.setId(13);
        this.subscription.setFolderId("12");
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        subscriptions.add(this.subscription);
        subscriptions.add(subscription2);
        this.subscribeService.setSubscriptions(subscriptions);
        SimFolderUpdaterService simFolderUpdaterService2 = new SimFolderUpdaterService();
        simFolderUpdaterService2.setHandles(true);
        simFolderUpdaterService2.setUsesMultipleStrategy(true);
        ArrayList<SimFolderUpdaterService> list = new ArrayList<SimFolderUpdaterService>(2);
        list.add(this.simFolderUpdaterService);
        list.add(simFolderUpdaterService2);
        this.executionService = new SubscriptionExecutionServiceImpl(this.discovery, list, (ContextService)new SimContextService()){

            protected FolderObject getFolder(TargetFolderSession subscriptionSession, int contextId, int folderId) throws OXException {
                return null;
            }
        };
        SubscriptionExecutionServiceImplTest.assertEquals((String)"The second Updater should be returned", (Object)simFolderUpdaterService2, (Object)this.executionService.getFolderUpdater((TargetFolderDefinition)this.subscription));
    }

    public void testShouldReturnSingleUpdaterIfThereAreTwoSubscriptionsOnTheFolderButNoMultipleStrategyIsAvailable() throws OXException {
        Subscription subscription2 = new Subscription();
        this.subscription.setContext((Context)new SimContext(2));
        this.subscription.setId(13);
        this.subscription.setFolderId("12");
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        subscriptions.add(this.subscription);
        subscriptions.add(subscription2);
        this.subscribeService.setSubscriptions(subscriptions);
        ArrayList<SimFolderUpdaterService> list = new ArrayList<SimFolderUpdaterService>(1);
        list.add(this.simFolderUpdaterService);
        this.executionService = new SubscriptionExecutionServiceImpl(this.discovery, list, (ContextService)new SimContextService()){

            protected FolderObject getFolder(TargetFolderSession subscriptionSession, int contextId, int folderId) throws OXException {
                return null;
            }
        };
        SubscriptionExecutionServiceImplTest.assertEquals((String)"The first Updater should be returned", (Object)this.simFolderUpdaterService, (Object)this.executionService.getFolderUpdater((TargetFolderDefinition)this.subscription));
    }
}

