/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;

public class Asserts {
    public static void assertKnows(SubscriptionSourceDiscoveryService discoverer, String id) {
        Assert.assertTrue((String)("Did not know: " + id), (boolean)discoverer.knowsSource(id));
    }

    public static void assertDoesNotKnow(SubscriptionSourceDiscoveryService discoverer, String id) {
        Assert.assertFalse((String)("Did know: " + id), (boolean)discoverer.knowsSource(id));
    }

    public static void assertSources(List<SubscriptionSource> sources, String ... expectedIdentifiers) {
        ArrayList<String> identifier = new ArrayList<String>();
        for (SubscriptionSource source : sources) {
            identifier.add(source.getId());
        }
        List<String> expectedList = Arrays.asList(expectedIdentifiers);
        Assert.assertEquals((String)("Expected: " + expectedList + " Got: " + identifier), (long)sources.size(), (long)expectedIdentifiers.length);
        HashSet actual = new HashSet(identifier);
        for (String expected : expectedIdentifiers) {
            Assert.assertTrue((String)("Expected: " + expectedList + " Got: " + identifier + " Missing: " + expected), (boolean)actual.remove(expected));
        }
        Assert.assertTrue((String)("Expected: " + expectedList + " Got: " + identifier), (boolean)actual.isEmpty());
    }

    public static void assertPriority(List<SubscriptionSource> sources, String identifier, int priority) {
        for (SubscriptionSource subscriptionSource : sources) {
            if (!subscriptionSource.getId().equals(identifier)) continue;
            Assert.assertEquals((long)priority, (long)subscriptionSource.getPriority());
            return;
        }
        Assert.fail((String)("Did not found subscription source with identifier " + identifier));
    }

    public static void assertPriority(SubscriptionSource source, int priority) {
        Assert.assertEquals((long)priority, (long)source.getPriority());
    }
}

