/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.mail.transport.config.MailAccountTransportProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.SMTPProperties;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailAccountSMTPProperties
extends MailAccountTransportProperties
implements ISMTPProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MailAccountSMTPProperties.class);
    private static final int PRIMARY = 0;
    private final int mailAccountId;

    public MailAccountSMTPProperties(MailAccount mailAccount) {
        super(mailAccount);
        this.mailAccountId = mailAccount.getId();
    }

    @Override
    public String getSmtpAuthEnc() {
        String smtpAuthEncStr = (String)this.properties.get("com.openexchange.smtp.smtpAuthEnc");
        if (null != smtpAuthEncStr) {
            if (Charset.isSupported(smtpAuthEncStr)) {
                return smtpAuthEncStr;
            }
            String fallback = SMTPProperties.getInstance().getSmtpAuthEnc();
            LOG.error("SMTP Auth Encoding: Unsupported charset \"{}\". Setting to fallback {}", (Object)smtpAuthEncStr, (Object)fallback);
            return fallback;
        }
        if (this.mailAccountId == 0 && null != (smtpAuthEncStr = this.lookUpProperty("com.openexchange.smtp.primary.smtpAuthEnc"))) {
            if (Charset.isSupported(smtpAuthEncStr)) {
                return smtpAuthEncStr;
            }
            String fallback = SMTPProperties.getInstance().getSmtpAuthEnc();
            LOG.error("SMTP Auth Encoding: Unsupported charset \"{}\". Setting to fallback {}", (Object)smtpAuthEncStr, (Object)fallback);
            return fallback;
        }
        return SMTPProperties.getInstance().getSmtpAuthEnc();
    }

    @Override
    public int getSmtpConnectionTimeout() {
        String smtpConTimeoutStr = (String)this.properties.get("com.openexchange.smtp.smtpConnectionTimeout");
        if (null != smtpConTimeoutStr) {
            try {
                return Integer.parseInt(smtpConTimeoutStr);
            }
            catch (NumberFormatException e) {
                LOG.error("SMTP Connection Timeout: Invalid value.", (Throwable)e);
                return SMTPProperties.getInstance().getSmtpConnectionTimeout();
            }
        }
        if (this.mailAccountId == 0 && null != (smtpConTimeoutStr = this.lookUpProperty("com.openexchange.smtp.primary.smtpConnectionTimeout"))) {
            try {
                return Integer.parseInt(smtpConTimeoutStr);
            }
            catch (NumberFormatException e) {
                LOG.error("SMTP Connection Timeout: Invalid value.", (Throwable)e);
                return SMTPProperties.getInstance().getSmtpConnectionTimeout();
            }
        }
        return SMTPProperties.getInstance().getSmtpConnectionTimeout();
    }

    @Override
    public String getSmtpLocalhost() {
        String smtpLocalhostStr = (String)this.properties.get("com.openexchange.smtp.smtpLocalhost");
        if (null != smtpLocalhostStr) {
            return smtpLocalhostStr.length() == 0 || "null".equalsIgnoreCase(smtpLocalhostStr) ? null : smtpLocalhostStr;
        }
        if (this.mailAccountId == 0 && null != (smtpLocalhostStr = this.lookUpProperty("com.openexchange.smtp.primary.smtpLocalhost"))) {
            return smtpLocalhostStr.length() == 0 || "null".equalsIgnoreCase(smtpLocalhostStr) ? null : smtpLocalhostStr;
        }
        return SMTPProperties.getInstance().getSmtpLocalhost();
    }

    @Override
    public int getSmtpTimeout() {
        String smtpTimeoutStr = (String)this.properties.get("com.openexchange.smtp.smtpTimeout");
        if (null != smtpTimeoutStr) {
            try {
                return Integer.parseInt(smtpTimeoutStr.trim());
            }
            catch (NumberFormatException e) {
                LOG.error("SMTP Timeout: Invalid value.", (Throwable)e);
                return SMTPProperties.getInstance().getSmtpTimeout();
            }
        }
        if (this.mailAccountId == 0 && null != (smtpTimeoutStr = this.lookUpProperty("com.openexchange.smtp.primary.smtpTimeout"))) {
            try {
                return Integer.parseInt(smtpTimeoutStr.trim());
            }
            catch (NumberFormatException e) {
                LOG.error("SMTP Timeout: Invalid value.", (Throwable)e);
                return SMTPProperties.getInstance().getSmtpTimeout();
            }
        }
        return SMTPProperties.getInstance().getSmtpTimeout();
    }

    @Override
    public boolean isSmtpAuth() {
        String smtpAuthStr = (String)this.properties.get("com.openexchange.smtp.smtpAuthentication");
        if (null != smtpAuthStr) {
            return Boolean.parseBoolean(smtpAuthStr.trim());
        }
        if (this.mailAccountId == 0 && null != (smtpAuthStr = this.lookUpProperty("com.openexchange.smtp.primary.smtpAuthentication"))) {
            return Boolean.parseBoolean(smtpAuthStr.trim());
        }
        return SMTPProperties.getInstance().isSmtpAuth();
    }

    @Override
    public boolean isSendPartial() {
        String smtpPartialStr = (String)this.properties.get("com.openexchange.smtp.sendPartial");
        if (null != smtpPartialStr) {
            return Boolean.parseBoolean(smtpPartialStr.trim());
        }
        if (this.mailAccountId == 0 && null != (smtpPartialStr = this.lookUpProperty("com.openexchange.smtp.primary.sendPartial"))) {
            return Boolean.parseBoolean(smtpPartialStr.trim());
        }
        return SMTPProperties.getInstance().isSendPartial();
    }

    @Override
    public boolean isSmtpEnvelopeFrom() {
        if (this.mailAccountId != 0) {
            return false;
        }
        String smtpEnvFromStr = (String)this.properties.get("com.openexchange.smtp.setSMTPEnvelopeFrom");
        if (null == smtpEnvFromStr) {
            return SMTPProperties.getInstance().isSmtpEnvelopeFrom();
        }
        return Boolean.parseBoolean(smtpEnvFromStr);
    }

    @Override
    public boolean isLogTransport() {
        if (this.mailAccountId != 0) {
            return false;
        }
        String tmp = (String)this.properties.get("com.openexchange.smtp.logTransport");
        if (null == tmp) {
            return SMTPProperties.getInstance().isLogTransport();
        }
        return Boolean.parseBoolean(tmp);
    }

    @Override
    public String getSSLProtocols() {
        String tmp = (String)this.properties.get("com.openexchange.smtp.ssl.protocols");
        if (null != tmp) {
            return tmp.trim();
        }
        if (this.mailAccountId == 0 && null != (tmp = this.lookUpProperty("com.openexchange.smtp.primary.ssl.protocols"))) {
            return tmp.trim();
        }
        return SMTPProperties.getInstance().getSSLProtocols();
    }

    @Override
    public String getSSLCipherSuites() {
        String tmp = (String)this.properties.get("com.openexchange.smtp.ssl.ciphersuites");
        if (null != tmp) {
            return tmp.trim();
        }
        if (this.mailAccountId == 0 && null != (tmp = this.lookUpProperty("com.openexchange.smtp.primary.ssl.ciphersuites"))) {
            return tmp.trim();
        }
        return SMTPProperties.getInstance().getSSLCipherSuites();
    }
}

