/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.smtp.SMTPProvider;

public enum SMTPExceptionCode implements DisplayableOXExceptionCode
{
    IO_ERROR(MailExceptionCode.IO_ERROR.getMessage(), MailExceptionCode.IO_ERROR.getCategory(), MailExceptionCode.IO_ERROR.getNumber()),
    ENCODING_ERROR(MailExceptionCode.ENCODING_ERROR.getMessage(), MailExceptionCode.ENCODING_ERROR.getCategory(), MailExceptionCode.ENCODING_ERROR.getNumber()),
    PART_NOT_FOUND("The message part with sequence ID %1$s could not be found in message %2$s in folder %3$s", CATEGORY_ERROR, 3003),
    HTML2TEXT_CONVERTER_ERROR("Html-2-Text conversion failed: %1$s", CATEGORY_ERROR, 3004),
    INTERNAL_ERROR("An internal error occurred: %1$s", CATEGORY_ERROR, 3005),
    MISSING_RECIPIENTS("There are no recipient(s) for the new message.", CATEGORY_USER_INPUT, 3006, "There are no recipient(s) for the new message."),
    COPY_TO_SENT_FOLDER_FAILED(MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.getMessage(), MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.getCategory(), MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.getNumber()),
    MISSING_NOTIFICATION_HEADER("Receipt acknowledgment cannot be sent: missing header %1$s in message %2$s", CATEGORY_ERROR, 3008),
    NO_SEND_ADDRESS_FOUND("No send address could be found in user configuration", CATEGORY_ERROR, 3009),
    NO_CONTENT("No content available in mail part", CATEGORY_ERROR, 3010),
    COPY_TO_SENT_FOLDER_FAILED_QUOTA(MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.getMessage(), MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.getCategory(), MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.getNumber()),
    NOT_CONNECTED("No storage access because mail connection is not connected", CATEGORY_ERROR, 3012),
    URI_PARSE_FAILED("Unable to parse SMTP server URI \"%1$s\".", CATEGORY_CONFIGURATION, 3013),
    RECIPIENT_NOT_ALLOWED("The following recipient is not allowed: %1$s. Please remove associated address and try again.", CATEGORY_USER_INPUT, 3014),
    SECURE_CONNECTION_NOT_POSSIBLE("The SMTP server %1$s cannot be accessed using a secure SSL connection for user %2$s. Please change configuration accordingly.", CATEGORY_USER_INPUT, 3015);

    private static final String PART_NOT_FOUND_MSG = "The message part with sequence ID %1$s could not be found in message %2$s in folder %3$s";
    private static final String HTML2TEXT_CONVERTER_ERROR_MSG = "Html-2-Text conversion failed: %1$s";
    private static final String INTERNAL_ERROR_MSG = "An internal error occurred: %1$s";
    private static final String MISSING_NOTIFICATION_HEADER_MSG = "Receipt acknowledgment cannot be sent: missing header %1$s in message %2$s";
    private static final String NO_SEND_ADDRESS_FOUND_MSG = "No send address could be found in user configuration";
    private static final String NO_CONTENT_MSG = "No content available in mail part";
    private static final String NOT_CONNECTED_MSG = "No storage access because mail connection is not connected";
    private static final String URI_PARSE_FAILED_MSG = "Unable to parse SMTP server URI \"%1$s\".";
    private static final String SECURE_CONNECTION_NOT_POSSIBLE_MSG = "The SMTP server %1$s cannot be accessed using a secure SSL connection for user %2$s. Please change configuration accordingly.";
    private final String message;
    private final int detailNumber;
    private final Category category;
    private final String prefix;
    private String displayMessage;

    private SMTPExceptionCode(String message, Category category, int detailNumber) {
        this(message, category, detailNumber, null);
    }

    private SMTPExceptionCode(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.prefix = SMTPProvider.PROTOCOL_SMTP.getName();
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

