/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.share.notification;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ShareNotifyExceptionCodes implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR_FOR_RECIPIENT("An unexpected error occurred: %1$s", "An error occurred, we were unable to send an email to \"%2$s\".", Category.CATEGORY_ERROR, 1),
    UNEXPECTED_ERROR("An unexpected error occurred: %1$s", "An error occurred, we were unable to send out the notification mails.", Category.CATEGORY_ERROR, 2),
    MISSING_MAIL_ADDRESS("Missing email address for user \"%1$s\" (%2$s) in context \"%3$s\"", "No notification mail could be sent to user \"%1$s\". We don't know his email address.", Category.CATEGORY_ERROR, 3),
    INVALID_MAIL_ADDRESS("\"%1$s\" is not a valid email address.", "\"%1$s\" is not a valid email address.", Category.CATEGORY_USER_INPUT, 4),
    UNKNOWN_NOTIFICATION_TRANSPORT("Unknown notification transport: %1$s.", null, Category.CATEGORY_ERROR, 5);

    public static final String PREFIX = "SHR_NOT";
    private final Category category;
    private final int number;
    private final String message;
    private final String displayMessage;

    private ShareNotifyExceptionCodes(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage == null ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
        this.number = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return null != this.displayMessage ? this.displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

