/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.sessiond.impl.IPRange;
import org.junit.Assert;
import org.junit.Test;

public class IPRangeTest {
    @Test
    public void simpleIP() {
        IPRange singleIP = IPRange.parseRange((String)"192.168.32.99");
        Assert.assertTrue((boolean)singleIP.contains("192.168.32.99"));
        Assert.assertFalse((boolean)singleIP.contains("192.168.32.98"));
    }

    @Test
    public void range() {
        IPRange range = IPRange.parseRange((String)"192.168.32.100-192.168.32.200");
        Assert.assertTrue((boolean)range.contains("192.168.32.150"));
        Assert.assertFalse((boolean)range.contains("192.168.32.99"));
        Assert.assertFalse((boolean)range.contains("191.168.32.150"));
    }

    @Test
    public void rangeWithCarryOver() {
        IPRange range = IPRange.parseRange((String)"192.168.32.99-192.168.33.20");
        Assert.assertTrue((boolean)range.contains("192.168.32.100"));
        Assert.assertTrue((boolean)range.contains("192.168.33.19"));
        Assert.assertFalse((boolean)range.contains("192.168.34.0"));
    }

    @Test
    public void rangeWithCarryOverIpv6() {
        IPRange range = IPRange.parseRange((String)"::1-::128");
        Assert.assertTrue((boolean)range.contains("::12"));
        Assert.assertTrue((boolean)range.contains("::24"));
        Assert.assertFalse((boolean)range.contains("::168"));
    }
}

