/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordchange;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.passwordchange.DefaultBasicPasswordChangeService;
import com.openexchange.passwordchange.PasswordChangeEvent;
import com.openexchange.passwordmechs.IPasswordMech;
import com.openexchange.passwordmechs.PasswordMech;
import com.openexchange.passwordmechs.PasswordMechFactory;
import com.openexchange.passwordmechs.PasswordMechFactoryImpl;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerServiceRegistry.class})
public class DefaultBasicPasswordChangeServiceTest {
    @InjectMocks
    private DefaultBasicPasswordChangeService service;
    @Mock
    private Session session;
    @Mock
    private Context context;
    @Mock
    private ServerServiceRegistry mockedServiceRegistry;
    private PasswordMechFactoryImpl factory;
    private final String password = "Schaaaalke04_schallallallallaaaa";

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(ServerServiceRegistry.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ServerServiceRegistry.getInstance()).thenReturn((Object)this.mockedServiceRegistry);
        this.factory = new PasswordMechFactoryImpl();
        this.factory.register(new IPasswordMech[]{PasswordMech.BCRYPT, PasswordMech.CRYPT, PasswordMech.SHA});
        PowerMockito.when((Object)this.mockedServiceRegistry.getService(PasswordMechFactory.class)).thenReturn((Object)this.factory);
    }

    @Test
    public void testPrepareUserUpdate_userHasPasswordMechSHA_returnUpdatedUserWithSHA() throws OXException {
        PasswordChangeEvent event = new PasswordChangeEvent(this.session, this.context, "neuesPasswort", "Schaaaalke04_schallallallallaaaa");
        UserImpl origUser = new UserImpl();
        origUser.setPasswordMech("{SHA}");
        origUser.setUserPassword(this.factory.get("{SHA}").encode("Schaaaalke04_schallallallallaaaa"));
        UserImpl updatedUser = new UserImpl();
        this.service.prepareUserUpdate(event, (User)origUser, updatedUser);
        Assert.assertEquals((Object)"{SHA}", (Object)updatedUser.getPasswordMech());
        Assert.assertNotNull((String)"Password should not be empty", (Object)updatedUser.getUserPassword());
    }

    @Test
    public void testPrepareUserUpdate_passwordMechEmpty_useBcryptAsDefault() throws OXException {
        PasswordChangeEvent event = new PasswordChangeEvent(this.session, this.context, "neuesPasswort", "Schaaaalke04_schallallallallaaaa");
        UserImpl origUser = new UserImpl();
        origUser.setPasswordMech("");
        UserImpl updatedUser = new UserImpl((User)origUser);
        this.service.prepareUserUpdate(event, (User)origUser, updatedUser);
        Assert.assertEquals((Object)"{BCRYPT}", (Object)updatedUser.getPasswordMech());
        Assert.assertNotNull((String)"Password should not be empty", (Object)updatedUser.getUserPassword());
    }

    @Test
    public void testPrepareUserUpdate_newPasswordEmpty_setEmptyPassword() throws OXException {
        PasswordChangeEvent event = new PasswordChangeEvent(this.session, this.context, "", "Schaaaalke04_schallallallallaaaa");
        UserImpl origUser = new UserImpl();
        UserImpl updatedUser = new UserImpl((User)origUser);
        this.service.prepareUserUpdate(event, (User)origUser, updatedUser);
        Assert.assertNull((Object)updatedUser.getUserPassword());
    }
}

