/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.mail.mime.ContentType;
import junit.framework.TestCase;

public class ContentTypeTest
extends TestCase {
    public void testTruncatedNameParameter() {
        try {
            String hdr = "application/pdf; name=The New York Times - Breaking News, World News & Multimedia.loc.pdf";
            ContentType contentType = new ContentType(hdr);
            String name = contentType.getNameParameter();
            ContentTypeTest.assertEquals((String)"Unexpected \"name\" parameter.", (String)"The New York Times - Breaking News, World News & Multimedia.loc.pdf", (String)name);
            ContentTypeTest.assertEquals((String)"Unexpected toString() result.", (String)"application/pdf; name=\"The New York Times - Breaking News, World News & Multimedia.loc.pdf\"", (String)contentType.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            ContentTypeTest.fail((String)e.getMessage());
        }
    }

    public void testWithCurlyBraces() {
        try {
            String hdr = "{\"application/octet-stream\"}; name=\"6N1911.pdf\"";
            ContentType contentType = new ContentType(hdr);
            ContentTypeTest.assertEquals((String)"Unexpected primary type", (String)"application", (String)contentType.getPrimaryType());
            ContentTypeTest.assertEquals((String)"Unexpected subtype", (String)"octet-stream", (String)contentType.getSubType());
            ContentTypeTest.assertEquals((String)"Unexpected name parameter", (String)"6N1911.pdf", (String)contentType.getNameParameter());
        }
        catch (Exception e) {
            e.printStackTrace();
            ContentTypeTest.fail((String)e.getMessage());
        }
    }

    public void testMalformedHeaderValue() {
        try {
            String hdr = "=?windows-1252?q?application/pdf; name=\"blatt8.pdf\"";
            ContentType contentType = new ContentType(hdr);
            ContentTypeTest.assertEquals((String)"Unexpected primary type", (String)"application", (String)contentType.getPrimaryType());
            ContentTypeTest.assertEquals((String)"Unexpected subtype", (String)"pdf", (String)contentType.getSubType());
            ContentTypeTest.assertEquals((String)"Unexpected name parameter", (String)"blatt8.pdf", (String)contentType.getNameParameter());
        }
        catch (Exception e) {
            e.printStackTrace();
            ContentTypeTest.fail((String)e.getMessage());
        }
    }
}

