/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.contact.ParsedDisplayName;
import junit.framework.TestCase;

public class ParsedDisplayNameTest
extends TestCase {
    public void testBasicParsing() {
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz otto").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("otto, heinz").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("otto, heinz").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("otto,heinz").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("otto,heinz").getSurName());
    }

    public void testPrefixTrimming() {
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("\"heinz otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("\"heinz otto").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName(" heinz otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName(" heinz otto").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("\theinz otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("\theinz otto").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("'heinz otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("'heinz otto").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("<heinz otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("<heinz otto").getSurName());
    }

    public void testSuffixTrimming() {
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz otto\"").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz otto\"").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz otto ").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz otto ").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz otto\t").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz otto\t").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz otto'").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz otto'").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz otto>").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz otto>").getSurName());
    }

    public void testLongerNames() {
        ParsedDisplayNameTest.assertEquals((String)"heinz horst albrecht", (String)new ParsedDisplayName("heinz horst albrecht otto").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("heinz horst albrecht otto").getSurName());
        ParsedDisplayNameTest.assertEquals((String)"heinz horst albrecht", (String)new ParsedDisplayName("otto, albrecht, horst, heinz").getGivenName());
        ParsedDisplayNameTest.assertEquals((String)"otto", (String)new ParsedDisplayName("otto, albrecht, horst, heinz").getSurName());
    }

    public void testShortNames() {
        ParsedDisplayNameTest.assertEquals((String)"heinz", (String)new ParsedDisplayName("heinz").getGivenName());
    }
}

