/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.oauth;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXActionAnnotationProcessor;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DefaultDispatcher;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.oauth.OAuthAnnotationProcessor;
import com.openexchange.ajax.requesthandler.oauth.OAuthDispatcherServlet;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.SimConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogProperties;
import com.openexchange.oauth.provider.exceptions.OAuthInsufficientScopeException;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidRequestException;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidTokenException;
import com.openexchange.oauth.provider.exceptions.OAuthRequestException;
import com.openexchange.oauth.provider.resourceserver.OAuthAccess;
import com.openexchange.oauth.provider.resourceserver.OAuthResourceService;
import com.openexchange.oauth.provider.resourceserver.SimOAuthResourceService;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthAction;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthModule;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthScopeCheck;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.SimpleServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SimServerSession;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.sim.SimHttpServletRequest;
import javax.servlet.http.sim.SimHttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OAuthDispatcherServletTest {
    private static final AJAXRequestResult RESULT = new AJAXRequestResult((Object)new Response(new JSONObject()));
    private OAuthDispatcherServlet servlet;
    private SimHttpServletRequest request;
    private SimHttpServletResponse response;
    private ByteArrayOutputStream responseStream;
    private SimOAuthResourceService resourceService;
    private String readToken;
    private String writeToken;
    private String readWriteToken;
    private String expiredToken;

    @BeforeClass
    public static void beforeClass() {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        dispatcher.register("test", (AJAXActionServiceFactory)new TestFactory());
        dispatcher.addAnnotationProcessor((AJAXActionAnnotationProcessor)new OAuthAnnotationProcessor());
        DispatcherServlet.setDispatcher((Dispatcher)dispatcher);
        DispatcherServlet.registerRenderer((ResponseRenderer)new APIResponseRenderer());
        ServerConfig.getInstance().initialize((ConfigurationService)new SimConfigurationService());
        DispatcherPrefixService dispatcherPrefixService = new DispatcherPrefixService(){

            public String getPrefix() {
                return "/ajax/";
            }
        };
        ServerServiceRegistry.getInstance().addService(DispatcherPrefixService.class, (Object)dispatcherPrefixService);
        Dispatchers.setDispatcherPrefixService((DispatcherPrefixService)dispatcherPrefixService);
    }

    @Before
    public void setUp() throws Exception {
        this.resourceService = new SimOAuthResourceService(new SimOAuthResourceService.SessionProvider(){

            public Session createSession(SimOAuthResourceService.TestGrant grant) {
                SimServerSession simServerSession = new SimServerSession(grant.getContextId(), grant.getUserId());
                simServerSession.setParameter(LogProperties.Name.DATABASE_SCHEMA.getName(), "db1");
                return simServerSession;
            }
        });
        SimOAuthResourceService.TestGrant readToken = new SimOAuthResourceService.TestGrant(1, 3, UUIDs.getUnformattedStringFromRandom(), UUIDs.getUnformattedStringFromRandom(), new Date(System.currentTimeMillis() + 3600000L), Scope.newInstance((String[])new String[]{"r_test"}));
        this.resourceService.addToken(readToken);
        this.readToken = readToken.getAccessToken();
        SimOAuthResourceService.TestGrant writeToken = new SimOAuthResourceService.TestGrant(1, 3, UUIDs.getUnformattedStringFromRandom(), UUIDs.getUnformattedStringFromRandom(), new Date(System.currentTimeMillis() + 3600000L), Scope.newInstance((String[])new String[]{"w_test"}));
        this.resourceService.addToken(writeToken);
        this.writeToken = writeToken.getAccessToken();
        SimOAuthResourceService.TestGrant readWriteToken = new SimOAuthResourceService.TestGrant(1, 3, UUIDs.getUnformattedStringFromRandom(), UUIDs.getUnformattedStringFromRandom(), new Date(System.currentTimeMillis() + 3600000L), Scope.newInstance((String[])new String[]{"r_test", "w_test"}));
        this.resourceService.addToken(readWriteToken);
        this.readWriteToken = readWriteToken.getAccessToken();
        SimOAuthResourceService.TestGrant expiredToken = new SimOAuthResourceService.TestGrant(1, 3, UUIDs.getUnformattedStringFromRandom(), UUIDs.getUnformattedStringFromRandom(), new Date(System.currentTimeMillis() - 1L), Scope.newInstance((String[])new String[]{"r_test"}));
        this.resourceService.addToken(expiredToken);
        this.expiredToken = expiredToken.getAccessToken();
        SimpleServiceLookup serviceLookup = new SimpleServiceLookup();
        serviceLookup.add(OAuthResourceService.class, (Object)this.resourceService);
        this.servlet = new OAuthDispatcherServlet((ServiceLookup)serviceLookup, "/ajax/");
        this.request = new SimHttpServletRequest();
        this.request.setMethod("GET");
        this.responseStream = new ByteArrayOutputStream();
        this.response = new SimHttpServletResponse();
        this.response.setCharacterEncoding("UTF-8");
        this.response.setOutputStream(new ServletOutputStream(){

            public void write(int b) throws IOException {
                OAuthDispatcherServletTest.this.responseStream.write(b);
            }
        });
    }

    private void prepareRequest(String action, String accessToken) {
        this.request.setServerName("appsuite.example.com");
        this.request.setServerPort(80);
        this.request.setRequestURI("/ajax/oauth/modules/test");
        this.request.setQueryString("action=" + action);
        this.request.setParameter("action", action);
        this.request.setContextPath("");
        this.request.setInputStream(new ServletInputStream(){

            public int read() throws IOException {
                return -1;
            }
        });
        if (accessToken != null) {
            this.request.setHeader("Authorization", "Bearer " + accessToken);
        }
    }

    @Test
    public void testMissingToken() throws Exception {
        this.prepareRequest("read", null);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(401);
        Assert.assertEquals((Object)"Bearer", (Object)this.response.getHeader("WWW-Authenticate"));
        Assert.assertEquals((long)0L, (long)this.responseStream.size());
    }

    @Test
    public void testMalformedToken() throws Exception {
        this.prepareRequest("read", "?!$");
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(401);
        String challenge = this.response.getHeader("WWW-Authenticate");
        OAuthInvalidTokenException expectedException = new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.TOKEN_MALFORMED);
        Assert.assertEquals((Object)("Bearer,error=\"invalid_token\",error_description=\"" + expectedException.getErrorDescription() + "\""), (Object)challenge);
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testUnknownToken() throws Exception {
        this.prepareRequest("read", "idontexist");
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(401);
        String challenge = this.response.getHeader("WWW-Authenticate");
        OAuthInvalidTokenException expectedException = new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.TOKEN_UNKNOWN);
        Assert.assertEquals((Object)("Bearer,error=\"invalid_token\",error_description=\"" + expectedException.getErrorDescription() + "\""), (Object)challenge);
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testExpiredToken() throws Exception {
        this.prepareRequest("read", this.expiredToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(401);
        String challenge = this.response.getHeader("WWW-Authenticate");
        OAuthInvalidTokenException expectedException = new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.TOKEN_EXPIRED);
        Assert.assertEquals((Object)("Bearer,error=\"invalid_token\",error_description=\"" + expectedException.getErrorDescription() + "\""), (Object)challenge);
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testInsufficientScope1() throws Exception {
        this.prepareRequest("write", this.readToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(403);
        OAuthInsufficientScopeException expectedException = new OAuthInsufficientScopeException("w_test");
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testInsufficientScope2() throws Exception {
        this.prepareRequest("readwrite", this.writeToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(403);
        OAuthInsufficientScopeException expectedException = new OAuthInsufficientScopeException();
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testCustomScopeCheck2() throws Exception {
        this.prepareRequest("readwrite", this.readToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(403);
        OAuthInsufficientScopeException expectedException = new OAuthInsufficientScopeException();
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testCustomScopeCheck3() throws Exception {
        this.prepareRequest("readwrite", this.writeToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(403);
        OAuthInsufficientScopeException expectedException = new OAuthInsufficientScopeException();
        this.assertErrorResponse((OAuthRequestException)expectedException);
    }

    @Test
    public void testCustomScopeCheck4() throws Exception {
        this.prepareRequest("readwrite", this.readWriteToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    @Test
    public void testGrantAllScope2() throws Exception {
        this.prepareRequest("unprivileged", this.readToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    @Test
    public void testScope1() throws Exception {
        this.prepareRequest("read", this.readToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    @Test
    public void testScope2() throws Exception {
        this.prepareRequest("write", this.writeToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    @Test
    public void testScope3() throws Exception {
        this.prepareRequest("readwrite", this.readWriteToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    @Test
    public void testScope4() throws Exception {
        this.prepareRequest("read", this.readWriteToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    @Test
    public void testScope5() throws Exception {
        this.prepareRequest("write", this.readWriteToken);
        this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        this.assertStatus(200);
    }

    private void assertStatus(int statusCode) {
        Assert.assertEquals((long)statusCode, (long)this.response.getStatus());
    }

    private void assertErrorResponse(OAuthRequestException e) throws JSONException {
        Assert.assertEquals((Object)"application/json;charset=UTF-8", (Object)this.response.getHeader("Content-Type"));
        JSONObject json = JSONObject.parse((Reader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.responseStream.toByteArray())))).toObject();
        Assert.assertNotNull((Object)json);
        if (e instanceof OAuthInvalidTokenException) {
            Assert.assertEquals((Object)"invalid_token", (Object)json.get("error"));
        } else if (e instanceof OAuthInsufficientScopeException) {
            Assert.assertEquals((Object)"insufficient_scope", (Object)json.get("error"));
            String requiredScope = ((OAuthInsufficientScopeException)e).getScope();
            if (requiredScope != null) {
                Assert.assertEquals((Object)requiredScope, (Object)json.get("scope"));
            }
        } else if (e instanceof OAuthInvalidRequestException) {
            Assert.assertEquals((Object)"invalid_request", (Object)json.get("error"));
        } else {
            Assert.fail((String)("Unknown exception: " + e.getClass().getName()));
        }
        String errorDescription = e.getErrorDescription();
        if (errorDescription != null) {
            Assert.assertEquals((Object)errorDescription, (Object)json.get("error_description"));
        }
    }

    static {
        try {
            ((Response)RESULT.getResultObject()).setData((Object)new JSONObject("{'ok':true}"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @OAuthModule
    private static final class TestFactory
    implements AJAXActionServiceFactory {
        private final Map<String, AJAXActionService> services = new HashMap<String, AJAXActionService>();

        private TestFactory() {
            this.services.put("read", new ReadAction());
            this.services.put("write", new WriteAction());
            this.services.put("readwrite", new CustomAction());
            this.services.put("unprivileged", new GrantAllAction());
        }

        public Collection<?> getSupportedServices() {
            return null;
        }

        public AJAXActionService createActionService(String action) throws OXException {
            return this.services.get(action);
        }

        @OAuthAction(value="__custom__")
        private final class CustomAction
        implements AJAXActionService {
            private CustomAction() {
            }

            public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
                return RESULT;
            }

            @OAuthScopeCheck
            public boolean checkScope(AJAXRequestData requestData, ServerSession session, OAuthAccess access) {
                return access.getScope().has("r_test") && access.getScope().has("w_test");
            }
        }

        @OAuthAction(value="w_test")
        private final class WriteAction
        implements AJAXActionService {
            private WriteAction() {
            }

            public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
                return RESULT;
            }
        }

        @OAuthAction(value="r_test")
        private final class ReadAction
        implements AJAXActionService {
            private ReadAction() {
            }

            public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
                return RESULT;
            }
        }

        @OAuthAction(value="*")
        private final class GrantAllAction
        implements AJAXActionService {
            private GrantAllAction() {
            }

            public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
                return RESULT;
            }
        }
    }
}

