/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewConst;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewImageGenerator;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewThumbResultConverter;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ThreadPools.class, PreviewImageGenerator.class})
public class PreviewThumbResultConverterTest {
    private static final String ETAG_VALUE = "http://www.open-xchange.com/infostore/258086/7/1409843861900";
    private ConfigurationService allowedConfig;
    private ConfigurationService forbiddenConfig;
    private AJAXRequestData requestData;
    private AJAXRequestResult result;
    private ServerSession session;
    private ResourceCache resourceCache;
    private CachedResource aResource = new CachedResource(new byte[]{1}, "cachedResource", "image/jpeg", 1L);
    private CachedResource noResource = null;
    private Future voidFuture = null;
    private ExecutorService executorService;
    private PreviewThumbResultConverter converter;
    private PreviewDocument previewDocument;
    private PreviewService previewService;

    @Before
    public void setUp() throws Exception {
        this.allowedConfig = (ConfigurationService)Mockito.mock(ConfigurationService.class);
        Mockito.when((Object)this.allowedConfig.getBoolProperty(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)true);
        this.forbiddenConfig = (ConfigurationService)Mockito.mock(ConfigurationService.class);
        Mockito.when((Object)this.forbiddenConfig.getBoolProperty(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)false);
        this.session = (ServerSession)Mockito.mock(ServerSession.class);
        Mockito.when((Object)this.session.getContextId()).thenReturn((Object)1);
        Mockito.when((Object)this.session.getUserId()).thenReturn((Object)1);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getPreferredLanguage()).thenReturn((Object)"de/de");
        Mockito.when((Object)this.session.getUser()).thenReturn((Object)user);
        this.requestData = new AJAXRequestData(){
            {
                this.setSession(PreviewThumbResultConverterTest.this.session);
                this.putParameter("width", "160");
                this.putParameter("height", "160");
                this.putParameter("scaleType", "cover");
                this.putParameter("content_type", "image/jpeg");
                this.putParameter("delivery", "view");
            }
        };
        this.result = new AJAXRequestResult();
        this.result.setHeader("ETag", ETAG_VALUE);
        this.resourceCache = (ResourceCache)Mockito.mock(ResourceCache.class);
        Mockito.when((Object)this.resourceCache.isEnabledFor(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)true);
        ResourceCaches.setResourceCache((ResourceCache)this.resourceCache);
        this.previewService = (PreviewService)Mockito.mock(PreviewService.class);
        ServerServiceRegistry.getInstance().addService(PreviewService.class, (Object)this.previewService);
        this.voidFuture = (Future)Mockito.mock(Future.class);
        Mockito.when(this.voidFuture.get(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn(null);
        this.executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when(this.executorService.submit((Runnable)Matchers.any(Runnable.class))).thenReturn((Object)this.voidFuture);
        PowerMockito.mockStatic(ThreadPools.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ThreadPools.getExecutorService()).thenReturn((Object)this.executorService);
        this.result = new AJAXRequestResult();
        this.result.setHeader("ETag", ETAG_VALUE);
    }

    @Test
    public void testConvertWithoutCachedResult() throws OXException {
        Mockito.when((Object)this.resourceCache.isEnabledFor(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)this.resourceCache.get(Matchers.anyString(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)this.noResource);
        this.converter = new PreviewThumbResultConverter(this.allowedConfig);
        this.converter.convert(this.requestData, this.result, this.session, null);
        Assert.assertNotNull((Object)this.result.getResultObject());
        FileHolder resultObject = (FileHolder)this.result.getResultObject();
        Assert.assertEquals((long)PreviewConst.MISSING_THUMBNAIL.length, (long)resultObject.getLength());
        Assert.assertEquals((long)200L, (long)this.result.getHttpStatusCode());
    }

    @Test
    public void testConvertWithCachedResult() throws OXException {
        Mockito.when((Object)this.resourceCache.isEnabledFor(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)this.resourceCache.get(Matchers.anyString(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)this.aResource);
        this.converter = new PreviewThumbResultConverter(this.allowedConfig);
        this.converter.convert(this.requestData, this.result, this.session, null);
        Assert.assertNotNull((Object)this.result.getResultObject());
        Assert.assertEquals((long)200L, (long)this.result.getHttpStatusCode());
        Assert.assertNull((Object)this.result.getHeader("Retry-After"));
    }

    @Test
    public void testConvertWithoutCacheBlockingAllowed() throws OXException {
        Mockito.when((Object)this.resourceCache.isEnabledFor(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)false);
        this.result.setResultObject((Object)new ByteArrayFileHolder(new byte[]{1}));
        this.previewDocument = (PreviewDocument)Mockito.mock(PreviewDocument.class);
        Mockito.when((Object)this.previewDocument.getThumbnail()).thenReturn((Object)new ByteArrayInputStream(new byte[]{1}));
        HashMap<String, String> metadata = new HashMap<String, String>(1);
        metadata.put("resourcename", "image.jpg");
        Mockito.when((Object)this.previewDocument.getMetaData()).thenReturn(metadata);
        PowerMockito.mockStatic(PreviewImageGenerator.class, (Class[])new Class[0]);
        PowerMockito.when((Object)PreviewImageGenerator.getPreviewDocument((AJAXRequestResult)((AJAXRequestResult)Matchers.any(AJAXRequestResult.class)), (AJAXRequestData)((AJAXRequestData)Matchers.any(AJAXRequestData.class)), (ServerSession)((ServerSession)Matchers.any(ServerSession.class)), (PreviewService)((PreviewService)Matchers.any(PreviewService.class)), (long)Matchers.anyLong(), (boolean)Matchers.anyBoolean())).thenReturn((Object)this.previewDocument);
        this.converter = new PreviewThumbResultConverter(this.allowedConfig);
        this.converter.convert(this.requestData, this.result, this.session, null);
        Assert.assertNotNull((Object)this.result.getResultObject());
        Assert.assertEquals((long)200L, (long)this.result.getHttpStatusCode());
        Assert.assertNull((Object)this.result.getHeader("Retry-After"));
    }

    @Test(expected=OXException.class)
    public void testConvertWithoutCacheBlockingForbiden() throws OXException {
        Mockito.when((Object)this.resourceCache.isEnabledFor(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)false);
        this.converter = new PreviewThumbResultConverter(this.forbiddenConfig);
        this.converter.convert(this.requestData, this.result, this.session, null);
    }
}

