/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.Translator;
import com.openexchange.json.JSONAssertion;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.interfaces.UserSpecificPublicationTarget;
import com.openexchange.publish.json.PublicationTargetWriter;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationTargetWriterTest
extends TestCase {
    private PublicationTarget target;

    public void setUp() {
        this.target = new PublicationTarget();
        this.target.setId("com.openexchange.publish.test1");
        this.target.setDisplayName("Test 1 PubTarget");
        this.target.setIcon("http://example.invalid/icon.png");
        this.target.setModule("contacts");
        this.target.setFormDescription(new DynamicFormDescription());
    }

    public void testWriteObject() throws JSONException {
        JSONObject object = new PublicationTargetWriter(Translator.EMPTY).write(this.target, null, null);
        JSONAssertion assertion = new JSONAssertion().isObject().hasKey("id").withValue((Object)"com.openexchange.publish.test1").hasKey("displayName").withValue((Object)"Test 1 PubTarget").hasKey("icon").withValue((Object)"http://example.invalid/icon.png").hasKey("module").withValue((Object)"contacts").hasKey("formDescription").withValueArray().hasNoMoreKeys();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
    }

    public void testWriteArray() throws JSONException, OXException {
        JSONArray array = new PublicationTargetWriter(Translator.EMPTY).writeArray(this.target, new String[]{"id", "displayName", "icon", "module"}, null, null);
        JSONAssertion assertion = new JSONAssertion().isArray().withValues(new Object[]{this.target.getId(), this.target.getDisplayName(), this.target.getIcon(), this.target.getModule()});
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)array);
    }

    public void testUnknownColumn() throws JSONException {
        try {
            new PublicationTargetWriter(Translator.EMPTY).writeArray(this.target, new String[]{"id", "unkownColumn"}, null, null);
            PublicationTargetWriterTest.fail((String)"Expected exception");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public void testWriteUserSpecificForm() throws JSONException {
        TestTarget target = new TestTarget();
        target.setId("com.openexchange.publish.test1");
        target.setDisplayName("Test 1 PubTarget");
        target.setIcon("http://example.invalid/icon.png");
        target.setModule("contacts");
        JSONObject object = new PublicationTargetWriter(Translator.EMPTY).write((PublicationTarget)target, null, null);
        JSONArray array = object.getJSONArray("formDescription");
        PublicationTargetWriterTest.assertEquals((int)1, (int)array.length());
    }

    public void testWriteUserSpecificFormInArray() throws OXException, JSONException {
        TestTarget target = new TestTarget();
        target.setId("com.openexchange.publish.test1");
        target.setDisplayName("Test 1 PubTarget");
        target.setIcon("http://example.invalid/icon.png");
        target.setModule("contacts");
        JSONArray array = new PublicationTargetWriter(Translator.EMPTY).writeArray((PublicationTarget)target, new String[]{"formDescription"}, null, null);
        JSONArray formDescription = array.getJSONArray(0);
        PublicationTargetWriterTest.assertEquals((int)1, (int)formDescription.length());
    }

    private static final class TestTarget
    extends PublicationTarget
    implements UserSpecificPublicationTarget {
        private TestTarget() {
        }

        public DynamicFormDescription getUserSpecificDescription(User user, UserPermissionBits permissionBits) {
            return new DynamicFormDescription().add(FormElement.input((String)"userSpecific", (String)"User Specific"));
        }
    }
}

