/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SimPublicationTargetDiscoveryService
implements PublicationTargetDiscoveryService {
    private final Map<String, PublicationTarget> targets = new HashMap<String, PublicationTarget>();

    public void addTarget(PublicationTarget target) {
        this.targets.put(target.getId(), target);
    }

    public Collection<PublicationTarget> listTargets() {
        return this.targets.values();
    }

    public boolean knows(String id) {
        return this.targets.containsKey(id);
    }

    public PublicationTarget getTarget(String id) {
        return this.targets.get(id);
    }

    public PublicationTarget getTarget(Context context, int publicationId) throws OXException {
        for (PublicationTarget target : this.targets.values()) {
            if (!target.getPublicationService().knows(context, publicationId)) continue;
            return target;
        }
        return null;
    }

    public Collection<PublicationTarget> getTargetsForEntityType(String module) {
        ArrayList<PublicationTarget> targets = new ArrayList<PublicationTarget>();
        for (PublicationTarget target : this.targets.values()) {
            if (!target.isResponsibleFor(module)) continue;
            targets.add(target);
        }
        return targets;
    }
}

