/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.console;

import com.openexchange.osgi.console.ServiceState;
import com.openexchange.osgi.console.ServiceStateLookup;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public final class ServiceStateCommandProvider
implements CommandProvider {
    private final ServiceStateLookup stateLookup;

    public ServiceStateCommandProvider(ServiceStateLookup stateLookup) {
        this.stateLookup = stateLookup;
    }

    public Object _serviceState(CommandInterpreter intp) {
        String bundleName = intp.nextArgument();
        if (bundleName == null) {
            List<String> names = this.stateLookup.getNames();
            Collections.sort(names);
            for (String name : names) {
                this.print(name, this.stateLookup.determineState(name), intp);
            }
        } else {
            this.print(bundleName, this.stateLookup.determineState(bundleName), intp);
        }
        return null;
    }

    private void print(String name, ServiceState state, CommandInterpreter intp) {
        StringBuilder builder = new StringBuilder();
        builder.append("=====[").append(name).append("]=====");
        intp.println((Object)builder);
        if (state == null) {
            intp.println((Object)"Nothing known. Sorry.");
            return;
        }
        List<String> missing = state.getMissingServices();
        List<String> present = state.getPresentServices();
        intp.println((Object)("Present (" + present.size() + ")"));
        this.print(present, intp);
        intp.println((Object)("Missing (" + missing.size() + ")"));
        this.print(missing, intp);
    }

    private void print(List<String> list, CommandInterpreter intp) {
        for (String string : list) {
            intp.println((Object)("\t" + string));
        }
    }

    public Object _missing(CommandInterpreter intp) {
        String bundleName = intp.nextArgument();
        if (bundleName == null) {
            List<String> names = this.stateLookup.getNames();
            Collections.sort(names);
            for (String name : names) {
                ServiceState state = this.stateLookup.determineState(name);
                List<String> services = state.getMissingServices();
                if (services.isEmpty()) continue;
                intp.println((Object)("=====[" + name + " Missing Services ]====="));
                this.print(services, intp);
            }
        } else {
            ServiceState state = this.stateLookup.determineState(bundleName);
            List<String> services = state.getMissingServices();
            if (!services.isEmpty()) {
                intp.println((Object)("=====[" + bundleName + " Missing Services]====="));
                this.print(services, intp);
            } else {
                intp.println((Object)"All services were found");
            }
        }
        return null;
    }

    public String getHelp() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("---Deferred Activator Services---\n\t");
        builder.append("serviceState - Print all service states. Give a bundle name as argument to list only the state of that bundle.\n\t");
        builder.append("missing - Print all bundles with missing services. Give a bundle name as argument to find the missing services for that bundle only.\n");
        return builder.toString();
    }
}

