/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import java.util.Stack;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeBundleActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeBundleActivator.class);
    private final Stack<BundleActivator> activated = new Stack();

    protected CompositeBundleActivator() {
    }

    public void start(BundleContext context) throws Exception {
        Exception first = null;
        for (BundleActivator activator : this.getActivators()) {
            try {
                activator.start(context);
                this.activated.push(activator);
            }
            catch (Exception e) {
                if (null == first) {
                    first = e;
                }
                LOG.error("Exception while running activator {}", (Object)activator.getClass().getName(), (Object)e);
            }
        }
        if (null != first) {
            throw first;
        }
    }

    public void stop(BundleContext context) throws Exception {
        Exception first = null;
        while (!this.activated.isEmpty()) {
            BundleActivator activator = this.activated.pop();
            try {
                activator.stop(context);
            }
            catch (Exception e) {
                if (null == first) {
                    first = e;
                }
                LOG.error("Exception while stopping activator {}", (Object)activator.getClass().getName(), (Object)e);
            }
        }
        if (null != first) {
            throw first;
        }
    }

    protected abstract BundleActivator[] getActivators();
}

