/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internal;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.generic.Utility;
import java.util.Collection;
import java.util.HashSet;
import javax.mail.Flags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalUtility {
    public static final String COLOR_LABEL_PREFIX = "$cl_";
    public static final String COLOR_LABEL_PREFIX_OLD = "cl_";
    public static final int COLOR_LABEL_NONE = 0;

    private InternalUtility() {
    }

    public static Flags convertMessagingFlags(int flags) {
        Flags flagsObj = new Flags();
        if ((flags & 1) == 1) {
            flagsObj.add(Flags.Flag.ANSWERED);
        }
        if ((flags & 2) == 2) {
            flagsObj.add(Flags.Flag.DELETED);
        }
        if ((flags & 4) == 4) {
            flagsObj.add(Flags.Flag.DRAFT);
        }
        if ((flags & 8) == 8) {
            flagsObj.add(Flags.Flag.FLAGGED);
        }
        if ((flags & 0x10) == 16) {
            flagsObj.add(Flags.Flag.RECENT);
        }
        if ((flags & 0x20) == 32) {
            flagsObj.add(Flags.Flag.SEEN);
        }
        if ((flags & 0x40) == 64) {
            flagsObj.add(Flags.Flag.USER);
        }
        if ((flags & 0x100) == 256) {
            flagsObj.add("$Forwarded");
        }
        if ((flags & 0x200) == 512) {
            flagsObj.add("$MDNSent");
        }
        return flagsObj;
    }

    public static int parseSystemFlags(Flags flags) {
        String[] userFlags;
        int retval = 0;
        if (flags.contains(Flags.Flag.ANSWERED)) {
            retval |= 1;
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            retval |= 2;
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            retval |= 4;
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            retval |= 8;
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            retval |= 0x10;
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            retval |= 0x20;
        }
        if (flags.contains(Flags.Flag.USER)) {
            retval |= 0x40;
        }
        if ((userFlags = flags.getUserFlags()) != null) {
            for (String userFlag : userFlags) {
                if ("$Forwarded".equalsIgnoreCase(userFlag)) {
                    retval |= 0x100;
                    continue;
                }
                if (!"$MDNSent".equalsIgnoreCase(userFlag)) continue;
                retval |= 0x200;
            }
        }
        return retval;
    }

    public static ParsedFlags parseFlags(Flags flags) throws OXException {
        String[] userFlags;
        int retval = 0;
        int colorLable = 0;
        HashSet<String> ufCol = null;
        if (flags.contains(Flags.Flag.ANSWERED)) {
            retval |= 1;
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            retval |= 2;
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            retval |= 4;
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            retval |= 8;
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            retval |= 0x10;
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            retval |= 0x20;
        }
        if (flags.contains(Flags.Flag.USER)) {
            retval |= 0x40;
        }
        if ((userFlags = flags.getUserFlags()) != null) {
            HashSet<String> set = new HashSet<String>(userFlags.length);
            for (String userFlag : userFlags) {
                if (InternalUtility.isColorLabel(userFlag)) {
                    colorLable = InternalUtility.getColorLabelIntValue(userFlag);
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(userFlag)) {
                    retval |= 0x100;
                    continue;
                }
                if ("$MDNSent".equalsIgnoreCase(userFlag)) {
                    retval |= 0x200;
                    continue;
                }
                set.add(userFlag);
            }
            ufCol = set.isEmpty() ? null : set;
        }
        return new ParsedFlags(retval, colorLable, ufCol);
    }

    public static int getColorLabelIntValue(String cl) throws OXException {
        if (!InternalUtility.isColorLabel(cl)) {
            throw MessagingExceptionCodes.UNKNOWN_COLOR_LABEL.create(new Object[]{cl});
        }
        try {
            return Integer.parseInt(cl.substring(cl.charAt(0) == '$' ? COLOR_LABEL_PREFIX.length() : COLOR_LABEL_PREFIX_OLD.length()));
        }
        catch (NumberFormatException e) {
            throw MessagingExceptionCodes.UNKNOWN_COLOR_LABEL.create(new Object[]{cl});
        }
    }

    public static boolean isColorLabel(String cl) {
        return cl != null && (cl.startsWith(COLOR_LABEL_PREFIX) || cl.startsWith(COLOR_LABEL_PREFIX_OLD));
    }

    public static int parseColorLabel(String cl, int defaultValue) {
        try {
            return Integer.parseInt(cl.substring('$' == cl.charAt(0) ? COLOR_LABEL_PREFIX.length() : COLOR_LABEL_PREFIX_OLD.length()));
        }
        catch (NumberFormatException e) {
            Logger log = LoggerFactory.getLogger(Utility.class);
            log.debug("Inbvalid color label: {}", (Object)cl, (Object)e);
            return defaultValue;
        }
    }

    public static String getColorLabelStringValue(int cl) {
        return COLOR_LABEL_PREFIX + cl;
    }

    public static final class ParsedFlags {
        private final int flags;
        private final int colorLabel;
        private final Collection<String> userFlags;

        ParsedFlags(int flags, int colorLabel, Collection<String> userFlags) {
            this.flags = flags;
            this.colorLabel = colorLabel;
            this.userFlags = userFlags;
        }

        public int getFlags() {
            return this.flags;
        }

        public Collection<String> getUserFlags() {
            return this.userFlags;
        }

        public int getColorLabel() {
            return this.colorLabel;
        }
    }
}

