/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.jslob.internal;

import com.openexchange.exception.OXException;
import com.openexchange.jslob.JSlobExceptionCodes;
import com.openexchange.jslob.JSlobService;
import com.openexchange.jslob.registry.JSlobServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JSlobServiceRegistryImpl
implements JSlobServiceRegistry {
    private static final JSlobServiceRegistryImpl INSTANCE = new JSlobServiceRegistryImpl();
    private final ConcurrentMap<String, JSlobService> registry = new ConcurrentHashMap<String, JSlobService>(2, 0.9f, 1);

    public static JSlobServiceRegistryImpl getInstance() {
        return INSTANCE;
    }

    private JSlobServiceRegistryImpl() {
    }

    @Override
    public JSlobService getJSlobService(String serviceId) throws OXException {
        JSlobService service = (JSlobService)this.registry.get(serviceId);
        if (null == service) {
            throw JSlobExceptionCodes.NOT_FOUND.create(serviceId);
        }
        return service;
    }

    @Override
    public JSlobService optJSlobService(String serviceId) throws OXException {
        return (JSlobService)this.registry.get(serviceId);
    }

    @Override
    public Collection<JSlobService> getJSlobServices() throws OXException {
        ArrayList<JSlobService> list = new ArrayList<JSlobService>(8);
        list.addAll(this.registry.values());
        return list;
    }

    @Override
    public boolean putJSlobService(JSlobService jslobService) {
        HashSet<String> keys = new HashSet<String>();
        if (null != this.registry.putIfAbsent(jslobService.getIdentifier(), jslobService)) {
            return false;
        }
        keys.add(jslobService.getIdentifier());
        List<String> aliases = jslobService.getAliases();
        if (null != aliases && !aliases.isEmpty()) {
            for (String alias : aliases) {
                if (null != this.registry.putIfAbsent(alias, jslobService)) {
                    for (String key : keys) {
                        this.registry.remove(key);
                    }
                    return false;
                }
                keys.add(alias);
            }
        }
        return true;
    }

    @Override
    public void removeJSlobService(JSlobService jslobService) throws OXException {
        this.registry.remove(jslobService.getIdentifier());
        List<String> aliases = jslobService.getAliases();
        if (null != aliases && !aliases.isEmpty()) {
            for (String alias : aliases) {
                this.registry.remove(alias);
            }
        }
    }
}

