/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.jslob;

import com.openexchange.exception.OXException;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobExceptionCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class JSONPathElement {
    private static final Pattern SPLIT = Pattern.compile("/");
    private final String name;
    private final int index;
    private static final int RADIX = 10;

    public static List<JSONPathElement> parsePath(String path) throws OXException {
        try {
            String[] fields = SPLIT.split(path, 0);
            ArrayList<JSONPathElement> list = new ArrayList<JSONPathElement>(fields.length);
            StringBuilder composite = null;
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (field.endsWith("\\")) {
                    if (composite == null) {
                        composite = new StringBuilder();
                    }
                    composite.append(field.substring(0, field.length() - 1)).append('/');
                    continue;
                }
                field = composite != null ? composite.toString() + field : field;
                composite = null;
                int pos = field.indexOf(91);
                if (pos >= 0) {
                    int index = JSONPathElement.getUnsignedInteger(field.substring(pos + 1, field.indexOf(93, pos + 1)));
                    String name = field.substring(0, pos);
                    list.add(new JSONPathElement(0 == name.length() ? null : name, index));
                    continue;
                }
                list.add(new JSONPathElement(field));
            }
            return list;
        }
        catch (IndexOutOfBoundsException e) {
            throw JSlobExceptionCodes.INVALID_PATH.create(path);
        }
    }

    public static Object getPathFrom(List<JSONPathElement> jPath, JSlob jslob) {
        return JSONPathElement.getPathFrom(jPath, jslob.getJsonObject());
    }

    public static Object getPathFrom(List<JSONPathElement> jPath, JSONObject jObject) {
        JSONObject jCurrent = jObject;
        int msize = jPath.size() - 1;
        for (int i = 0; i < msize; ++i) {
            JSONPathElement jPathElement = jPath.get(i);
            int index = jPathElement.getIndex();
            String name = jPathElement.getName();
            if (index >= 0) {
                if (JSONPathElement.isInstance(name, JSONArray.class, jCurrent)) {
                    try {
                        JSONArray jsonArray = jCurrent.getJSONArray(name);
                        jCurrent = jsonArray.getJSONObject(index);
                        continue;
                    }
                    catch (JSONException e) {
                        return null;
                    }
                }
                return null;
            }
            if (JSONPathElement.isInstance(name, JSONObject.class, jCurrent)) {
                try {
                    jCurrent = jCurrent.getJSONObject(name);
                    continue;
                }
                catch (JSONException e) {
                    return null;
                }
            }
            return null;
        }
        try {
            JSONPathElement leaf = jPath.get(msize);
            int index = leaf.getIndex();
            String name = leaf.getName();
            Object retval = index >= 0 ? jCurrent.getJSONArray(name).get(index) : jCurrent.get(name);
            if (retval instanceof JSONValue) {
                return null;
            }
            return retval;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Object remove(List<JSONPathElement> jPath, JSONObject jObject) {
        JSONObject jCurrent = jObject;
        Entry entry = new Entry(null, jObject, null);
        int msize = jPath.size() - 1;
        for (int i = 0; i < msize; ++i) {
            JSONPathElement jPathElement = jPath.get(i);
            int index = jPathElement.getIndex();
            String name = jPathElement.getName();
            if (index >= 0) {
                if (JSONPathElement.isInstance(name, JSONArray.class, jCurrent)) {
                    try {
                        JSONArray jsonArray = jCurrent.getJSONArray(name);
                        jCurrent = jsonArray.getJSONObject(index);
                        entry = new Entry(jPathElement, jCurrent, entry);
                        continue;
                    }
                    catch (JSONException e) {
                        return null;
                    }
                }
                return null;
            }
            if (JSONPathElement.isInstance(name, JSONObject.class, jCurrent)) {
                try {
                    jCurrent = jCurrent.getJSONObject(name);
                    entry = new Entry(jPathElement, jCurrent, entry);
                    continue;
                }
                catch (JSONException e) {
                    return null;
                }
            }
            return null;
        }
        try {
            Object retval;
            JSONPathElement leaf = jPath.get(msize);
            int index = leaf.getIndex();
            String name = leaf.getName();
            if (index >= 0) {
                retval = jCurrent.getJSONArray(name).get(index);
                JSONPathElement.removeOne(jCurrent.getJSONArray(name), index);
            } else {
                retval = jCurrent.get(name);
                jCurrent.remove(name);
            }
            if (retval instanceof JSONValue) {
                return null;
            }
            entry.removeIfEmpty();
            return retval;
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static void removeOne(JSONArray jsonArray, int theIndex) {
        ArrayList<Object> purged = new ArrayList<Object>(jsonArray.length());
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            if (i == theIndex) continue;
            try {
                purged.add(jsonArray.get(i));
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        jsonArray.reset();
        for (Object e : purged) {
            jsonArray.put(e);
        }
    }

    private static boolean isInstance(String name, Class<? extends JSONValue> clazz, JSONObject jsonObject) {
        if (!jsonObject.hasAndNotNull(name)) {
            return false;
        }
        return clazz.isInstance(jsonObject.opt(name));
    }

    public JSONPathElement(String name) {
        this(name, -1);
    }

    public JSONPathElement(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public boolean hasIndex() {
        return this.index >= 0;
    }

    public String toString() {
        if (this.index >= 0) {
            String cfr_ignored_0 = this.name + '[' + this.index + ']';
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = JSONPathElement.digitFor(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = JSONPathElement.digitFor(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digitFor(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    private static final class Entry {
        private Entry parent = null;
        private final JSONObject object;
        private final JSONPathElement name;

        public Entry(JSONPathElement name, JSONObject object, Entry parent) {
            this.name = name;
            this.object = object;
            this.parent = parent;
        }

        public void removeIfEmpty() {
            if (this.parent == null) {
                return;
            }
            try {
                boolean removed = false;
                if (JSONPathElement.isInstance(this.name.name, JSONArray.class, this.parent.object) && this.parent.object.getJSONArray(this.name.name).getJSONObject(this.name.index).length() == 0) {
                    JSONPathElement.removeOne(this.parent.object.getJSONArray(this.name.name), this.name.index);
                    if (this.parent.object.getJSONArray(this.name.name).length() == 0) {
                        this.parent.object.remove(this.name.name);
                    }
                    removed = true;
                } else if (this.parent.object.getJSONObject(this.name.name).length() == 0) {
                    this.parent.object.remove(this.name.name);
                    removed = true;
                }
                if (!removed) {
                    return;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (this.parent != null) {
                this.parent.removeIfEmpty();
            }
        }
    }
}

