/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.jslob;

import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import org.json.JSONObject;

public class DefaultJSlob
implements JSlob,
Cloneable {
    private static final long serialVersionUID = -9125059146804828888L;
    public static final DefaultJSlob EMPTY_JSLOB = new EmptyJSlob();
    private JSONObject jsonObject;
    private JSONObject metaObject;
    private JSlobId id;

    public DefaultJSlob() {
    }

    public DefaultJSlob(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        this.metaObject = new JSONObject();
    }

    public DefaultJSlob(JSlob other) {
        JSONObject jo = other.getJsonObject();
        this.jsonObject = null == jo ? null : new JSONObject(jo);
        jo = other.getMetaObject();
        this.metaObject = null == jo ? null : new JSONObject(jo);
        JSlobId otherId = other.getId();
        this.id = null == otherId ? null : new JSlobId(otherId.getServiceId(), otherId.getId(), otherId.getUser(), otherId.getContext());
    }

    @Override
    public JSlob clone() {
        try {
            DefaultJSlob clone = (DefaultJSlob)super.clone();
            clone.setId(this.id == null ? null : new JSlobId(this.id.getServiceId(), this.id.getId(), this.id.getUser(), this.id.getContext()));
            clone.setJsonObject(null == this.jsonObject ? null : new JSONObject(this.jsonObject));
            clone.setMetaObject(null == this.metaObject ? null : new JSONObject(this.metaObject));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("DefaultJSlob {");
        if (this.getJsonObject() != null) {
            builder.append("jsonObject=").append(this.getJsonObject()).append(", ");
        }
        if (this.getMetaObject() != null) {
            builder.append("metaObject=").append(this.getMetaObject()).append(", ");
        }
        if (this.getId() != null) {
            builder.append("id=").append(this.getId());
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public JSlobId getId() {
        return this.id;
    }

    @Override
    public DefaultJSlob setId(JSlobId id) {
        this.id = id;
        return this;
    }

    @Override
    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public JSlob setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        return this;
    }

    @Override
    public JSONObject getMetaObject() {
        return this.metaObject;
    }

    public JSlob setMetaObject(JSONObject metaObject) {
        this.metaObject = metaObject;
        return this;
    }

    private static final class EmptyJSlob
    extends DefaultJSlob {
        private static final long serialVersionUID = 870193683123103886L;

        protected EmptyJSlob() {
        }

        @Override
        public JSlob setJsonObject(JSONObject jsonObject) {
            throw new UnsupportedOperationException("EmptyJSlob.setJsonObject()");
        }

        @Override
        public DefaultJSlob setId(JSlobId id) {
            throw new UnsupportedOperationException("EmptyJSlob.setId()");
        }

        @Override
        public JSlob setMetaObject(JSONObject metaObject) {
            throw new UnsupportedOperationException("EmptyJSlob.setMetaObject()");
        }
    }
}

