/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception.interception;

import com.openexchange.exception.OXException;
import com.openexchange.exception.interception.AbstractOXExceptionInterceptor;
import com.openexchange.exception.interception.OXExceptionArguments;
import com.openexchange.exception.interception.OXExceptionInterceptor;
import com.openexchange.exception.interception.Responsibility;
import com.openexchange.exception.interception.internal.OXExceptionInterceptorRegistration;
import com.openexchange.test.mock.MockUtils;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class OXExceptionInterceptorRegistrationTest
extends TestCase {
    public void setUp() throws Exception {
        OXExceptionInterceptorRegistration.initInstance();
    }

    @Test
    public void testIsResponsibleInterceptorRegistered_completelySameInterceptor_returnFalse() {
        LinkedList<1> interceptors = new LinkedList<1>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        interceptors.add(oxExceptionInterceptor);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        AbstractOXExceptionInterceptor testInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        testInterceptor.addResponsibility(new Responsibility("module", "action"));
        boolean responsibleInterceptorRegistered = OXExceptionInterceptorRegistration.getInstance().isResponsibleInterceptorRegistered((OXExceptionInterceptor)testInterceptor);
        Assert.assertTrue((String)"A responsible interceptor might already be registered but cannot be found", (boolean)responsibleInterceptorRegistered);
    }

    @Test
    public void testIsResponsibleInterceptorRegistered_differentRanking_returnFalse() {
        LinkedList<3> interceptors = new LinkedList<3>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        interceptors.add(oxExceptionInterceptor);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        AbstractOXExceptionInterceptor testInterceptor = new AbstractOXExceptionInterceptor(11){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        testInterceptor.addResponsibility(new Responsibility("module", "action"));
        boolean responsibleInterceptorRegistered = OXExceptionInterceptorRegistration.getInstance().isResponsibleInterceptorRegistered((OXExceptionInterceptor)testInterceptor);
        Assert.assertFalse((String)"A responsible interceptor might NOT be registered but can be found", (boolean)responsibleInterceptorRegistered);
    }

    @Test
    public void testIsResponsibleInterceptorRegistered_compareManyInterceptorsWithManyResponsibilities_returnFalse() {
        LinkedList<AbstractOXExceptionInterceptor> interceptors = new LinkedList<AbstractOXExceptionInterceptor>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        interceptors.add(oxExceptionInterceptor);
        AbstractOXExceptionInterceptor registeredInterceptor1 = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor1.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor1.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor1.addResponsibility(new Responsibility("testModul2", "textAction2"));
        AbstractOXExceptionInterceptor registeredInterceptor2 = new AbstractOXExceptionInterceptor(2){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor2.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor2.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor2.addResponsibility(new Responsibility("testModul2", "textAction2"));
        AbstractOXExceptionInterceptor registeredInterceptor3 = new AbstractOXExceptionInterceptor(3){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor3.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor3.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor3.addResponsibility(new Responsibility("testModul2", "textAction2"));
        interceptors.add(registeredInterceptor1);
        interceptors.add(registeredInterceptor2);
        interceptors.add(registeredInterceptor3);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        AbstractOXExceptionInterceptor testInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable", "actionNotAvailable"));
        boolean responsibleInterceptorRegistered = OXExceptionInterceptorRegistration.getInstance().isResponsibleInterceptorRegistered((OXExceptionInterceptor)testInterceptor);
        Assert.assertFalse((String)"A responsible interceptor might NOT be registered but can be found", (boolean)responsibleInterceptorRegistered);
    }

    @Test
    public void testIsResponsibleInterceptorRegistered_compareManyInterceptorsWithManyResponsibilitiesWithTestInterceptorWithManyResponsibilities_returnFalse() {
        LinkedList<AbstractOXExceptionInterceptor> interceptors = new LinkedList<AbstractOXExceptionInterceptor>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        interceptors.add(oxExceptionInterceptor);
        AbstractOXExceptionInterceptor registeredInterceptor1 = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor1.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor1.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor1.addResponsibility(new Responsibility("testModul2", "textAction2"));
        AbstractOXExceptionInterceptor registeredInterceptor2 = new AbstractOXExceptionInterceptor(2){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor2.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor2.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor2.addResponsibility(new Responsibility("testModul2", "textAction2"));
        AbstractOXExceptionInterceptor registeredInterceptor3 = new AbstractOXExceptionInterceptor(3){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor3.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor3.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor3.addResponsibility(new Responsibility("testModul2", "textAction2"));
        interceptors.add(registeredInterceptor1);
        interceptors.add(registeredInterceptor2);
        interceptors.add(registeredInterceptor3);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        AbstractOXExceptionInterceptor testInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable", "actionNotAvailable"));
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable1", "actionNotAvailable1"));
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable2", "actionNotAvailable2"));
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable3", "actionNotAvailable3"));
        boolean responsibleInterceptorRegistered = OXExceptionInterceptorRegistration.getInstance().isResponsibleInterceptorRegistered((OXExceptionInterceptor)testInterceptor);
        Assert.assertFalse((String)"A responsible interceptor might NOT be registered but can be found", (boolean)responsibleInterceptorRegistered);
    }

    @Test
    public void testIsResponsibleInterceptorRegistered_sameResponsibilitiesButdifferentRanking_returnFalse() {
        LinkedList<AbstractOXExceptionInterceptor> interceptors = new LinkedList<AbstractOXExceptionInterceptor>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        interceptors.add(oxExceptionInterceptor);
        AbstractOXExceptionInterceptor registeredInterceptor1 = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor1.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor1.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor1.addResponsibility(new Responsibility("testModul2", "textAction2"));
        AbstractOXExceptionInterceptor registeredInterceptor2 = new AbstractOXExceptionInterceptor(2){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor2.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor2.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor2.addResponsibility(new Responsibility("testModul2", "textAction2"));
        AbstractOXExceptionInterceptor registeredInterceptor3 = new AbstractOXExceptionInterceptor(3){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        registeredInterceptor3.addResponsibility(new Responsibility("testModul", "textAction"));
        registeredInterceptor3.addResponsibility(new Responsibility("testModul1", "textAction1"));
        registeredInterceptor3.addResponsibility(new Responsibility("module", "action"));
        interceptors.add(registeredInterceptor1);
        interceptors.add(registeredInterceptor2);
        interceptors.add(registeredInterceptor3);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        AbstractOXExceptionInterceptor testInterceptor = new AbstractOXExceptionInterceptor(3){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable", "actionNotAvailable"));
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable1", "actionNotAvailable1"));
        testInterceptor.addResponsibility(new Responsibility("moduleNotAvailable2", "actionNotAvailable2"));
        testInterceptor.addResponsibility(new Responsibility("module", "action"));
        boolean responsibleInterceptorRegistered = OXExceptionInterceptorRegistration.getInstance().isResponsibleInterceptorRegistered((OXExceptionInterceptor)testInterceptor);
        Assert.assertTrue((String)"A responsible interceptor might already be registered but cannot be found", (boolean)responsibleInterceptorRegistered);
    }

    @Test
    public void testGetResponsibleInterceptors_noResponsibleRegisteredBecauseNoOneRegistered_returnEmptyList() {
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("moduleNotAvailable", "actionNotAvailable");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)0L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_noResponsibleRegistered_returnEmptyList() {
        LinkedList<20> interceptors = new LinkedList<20>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("moduleNotAvailable", "actionNotAvailable");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)0L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_oneResponsibleRegistered_returnOne() {
        LinkedList<21> interceptors = new LinkedList<21>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("module2", "action2");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)1L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_wrongAction_returnEmptyList() {
        LinkedList<22> interceptors = new LinkedList<22>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("module2", "action7");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)0L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_wrongModule_returnEmptyList() {
        LinkedList<23> interceptors = new LinkedList<23>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("module8", "action1");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)0L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_twoResponsibleRegistered_returnTwo() {
        LinkedList<AbstractOXExceptionInterceptor> interceptors = new LinkedList<AbstractOXExceptionInterceptor>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        AbstractOXExceptionInterceptor oxExceptionInterceptor1 = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor1);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("module1", "action1");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)2L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_ThreeRegisteredTwoResponsible_returnTwo() {
        LinkedList<AbstractOXExceptionInterceptor> interceptors = new LinkedList<AbstractOXExceptionInterceptor>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module11", "action12"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        AbstractOXExceptionInterceptor oxExceptionInterceptor1 = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor1);
        AbstractOXExceptionInterceptor oxExceptionInterceptor2 = new AbstractOXExceptionInterceptor(1){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor2.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor2.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor2.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor2);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("module1", "action1");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)2L, (long)responsibleInterceptors.size());
    }

    @Test
    public void testGetResponsibleInterceptors_fourRegistered_returnInCorrectOrder() {
        LinkedList<AbstractOXExceptionInterceptor> interceptors = new LinkedList<AbstractOXExceptionInterceptor>();
        AbstractOXExceptionInterceptor oxExceptionInterceptor = new AbstractOXExceptionInterceptor(Integer.MIN_VALUE){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor.addResponsibility(new Responsibility("module", "action"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module11", "action12"));
        oxExceptionInterceptor.addResponsibility(new Responsibility("module2", "action2"));
        interceptors.add(oxExceptionInterceptor);
        AbstractOXExceptionInterceptor oxExceptionInterceptor1 = new AbstractOXExceptionInterceptor(Integer.MAX_VALUE){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor1.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor1);
        AbstractOXExceptionInterceptor oxExceptionInterceptor2 = new AbstractOXExceptionInterceptor(1111){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor2.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor2.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor2.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor2);
        AbstractOXExceptionInterceptor oxExceptionInterceptor3 = new AbstractOXExceptionInterceptor(444){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor3.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor3.addResponsibility(new Responsibility("module1ignore", "action1ignore"));
        oxExceptionInterceptor3.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor3);
        AbstractOXExceptionInterceptor oxExceptionInterceptor4 = new AbstractOXExceptionInterceptor(55){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor4.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor4.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor4.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor4);
        AbstractOXExceptionInterceptor oxExceptionInterceptor5 = new AbstractOXExceptionInterceptor(333){

            public OXExceptionArguments intercept(OXException oxException) {
                return null;
            }
        };
        oxExceptionInterceptor5.addResponsibility(new Responsibility("module7", "action7"));
        oxExceptionInterceptor5.addResponsibility(new Responsibility("module1", "action1"));
        oxExceptionInterceptor5.addResponsibility(new Responsibility("module8", "action8"));
        interceptors.add(oxExceptionInterceptor5);
        MockUtils.injectValueIntoPrivateField((Object)OXExceptionInterceptorRegistration.getInstance(), (String)"interceptors", interceptors);
        List responsibleInterceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors("module1", "action1");
        Assert.assertEquals((String)"Wrong number of responsible interceptor found", (long)4L, (long)responsibleInterceptors.size());
        int lastRanking = Integer.MIN_VALUE;
        for (OXExceptionInterceptor interceptor : responsibleInterceptors) {
            Assert.assertTrue((String)"Wrong order of interceptors!", (lastRanking <= interceptor.getRanking() ? 1 : 0) != 0);
            lastRanking = interceptor.getRanking();
        }
    }
}

