/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.FileStorageAdvancedSearchFileAccess;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageETagProvider;
import com.openexchange.file.storage.FileStorageEfficientRetrieval;
import com.openexchange.file.storage.FileStorageExtendedMetadata;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageIgnorableVersionFileAccess;
import com.openexchange.file.storage.FileStorageLockedFileAccess;
import com.openexchange.file.storage.FileStorageMailAttachments;
import com.openexchange.file.storage.FileStorageMultiMove;
import com.openexchange.file.storage.FileStoragePersistentIDs;
import com.openexchange.file.storage.FileStorageRandomFileAccess;
import com.openexchange.file.storage.FileStorageRangeFileAccess;
import com.openexchange.file.storage.FileStorageReadOnly;
import com.openexchange.file.storage.FileStorageSequenceNumberProvider;
import com.openexchange.file.storage.FileStorageVersionedFileAccess;
import com.openexchange.file.storage.ObjectPermissionAware;
import com.openexchange.file.storage.ThumbnailAware;
import org.slf4j.LoggerFactory;

public class FileStorageCapabilityTools {
    private FileStorageCapabilityTools() {
    }

    public static Boolean supportsByClass(Class<? extends FileStorageFileAccess> fileAccessClass, FileStorageCapability capability) {
        switch (capability) {
            case FILE_VERSIONS: {
                return FileStorageVersionedFileAccess.class.isAssignableFrom(fileAccessClass);
            }
            case FOLDER_ETAGS: {
                return FileStorageETagProvider.class.isAssignableFrom(fileAccessClass);
            }
            case IGNORABLE_VERSION: {
                return FileStorageIgnorableVersionFileAccess.class.isAssignableFrom(fileAccessClass);
            }
            case PERSISTENT_IDS: {
                return FileStoragePersistentIDs.class.isAssignableFrom(fileAccessClass);
            }
            case RANDOM_FILE_ACCESS: {
                return FileStorageRandomFileAccess.class.isAssignableFrom(fileAccessClass);
            }
            case RECURSIVE_FOLDER_ETAGS: {
                return null;
            }
            case SEARCH_BY_TERM: {
                return FileStorageAdvancedSearchFileAccess.class.isAssignableFrom(fileAccessClass);
            }
            case SEQUENCE_NUMBERS: {
                return FileStorageSequenceNumberProvider.class.isAssignableFrom(fileAccessClass);
            }
            case THUMBNAIL_IMAGES: {
                return ThumbnailAware.class.isAssignableFrom(fileAccessClass);
            }
            case EFFICIENT_RETRIEVAL: {
                return FileStorageEfficientRetrieval.class.isAssignableFrom(fileAccessClass);
            }
            case LOCKS: {
                return FileStorageLockedFileAccess.class.isAssignableFrom(fileAccessClass);
            }
            case OBJECT_PERMISSIONS: {
                return ObjectPermissionAware.class.isAssignableFrom(fileAccessClass);
            }
            case RANGES: {
                return FileStorageRangeFileAccess.class.isAssignableFrom(fileAccessClass);
            }
            case EXTENDED_METADATA: {
                return FileStorageExtendedMetadata.class.isAssignableFrom(fileAccessClass);
            }
            case MULTI_MOVE: {
                return FileStorageMultiMove.class.isAssignableFrom(fileAccessClass);
            }
            case READ_ONLY: {
                return FileStorageReadOnly.class.isAssignableFrom(fileAccessClass);
            }
            case MAIL_ATTACHMENTS: {
                return FileStorageMailAttachments.class.isAssignableFrom(fileAccessClass);
            }
        }
        LoggerFactory.getLogger(FileStorageCapabilityTools.class).warn("Unknown capability: {}", (Object)capability);
        return Boolean.FALSE;
    }

    public static boolean supports(FileStorageFileAccess fileAccess, FileStorageCapability capability) {
        switch (capability) {
            case FILE_VERSIONS: {
                return FileStorageVersionedFileAccess.class.isInstance(fileAccess);
            }
            case FOLDER_ETAGS: {
                return FileStorageETagProvider.class.isInstance(fileAccess);
            }
            case IGNORABLE_VERSION: {
                return FileStorageIgnorableVersionFileAccess.class.isInstance(fileAccess);
            }
            case PERSISTENT_IDS: {
                return FileStoragePersistentIDs.class.isInstance(fileAccess);
            }
            case RANDOM_FILE_ACCESS: {
                return FileStorageRandomFileAccess.class.isInstance(fileAccess);
            }
            case RECURSIVE_FOLDER_ETAGS: {
                return FileStorageETagProvider.class.isInstance(fileAccess) && ((FileStorageETagProvider)((Object)fileAccess)).isRecursive();
            }
            case SEARCH_BY_TERM: {
                return FileStorageAdvancedSearchFileAccess.class.isInstance(fileAccess);
            }
            case SEQUENCE_NUMBERS: {
                return FileStorageSequenceNumberProvider.class.isInstance(fileAccess);
            }
            case THUMBNAIL_IMAGES: {
                return ThumbnailAware.class.isInstance(fileAccess);
            }
            case EFFICIENT_RETRIEVAL: {
                return FileStorageEfficientRetrieval.class.isInstance(fileAccess);
            }
            case LOCKS: {
                return FileStorageLockedFileAccess.class.isInstance(fileAccess);
            }
            case OBJECT_PERMISSIONS: {
                return ObjectPermissionAware.class.isInstance(fileAccess);
            }
            case RANGES: {
                return FileStorageRangeFileAccess.class.isInstance(fileAccess);
            }
            case EXTENDED_METADATA: {
                return FileStorageExtendedMetadata.class.isInstance(fileAccess);
            }
            case MULTI_MOVE: {
                return FileStorageMultiMove.class.isInstance(fileAccess);
            }
            case READ_ONLY: {
                return FileStorageReadOnly.class.isInstance(fileAccess);
            }
            case MAIL_ATTACHMENTS: {
                return FileStorageMailAttachments.class.isInstance(fileAccess);
            }
        }
        LoggerFactory.getLogger(FileStorageCapabilityTools.class).warn("Unknown capability: {}", (Object)capability);
        return false;
    }
}

