/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AdministrativeFileStorageFileAccess;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.Range;
import com.openexchange.file.storage.infostore.FileMetadata;
import com.openexchange.file.storage.infostore.InfostoreFile;
import com.openexchange.file.storage.infostore.internal.FieldMapping;
import com.openexchange.file.storage.infostore.internal.InfostoreAccess;
import com.openexchange.file.storage.infostore.internal.InfostoreTimedResult;
import com.openexchange.file.storage.infostore.osgi.Services;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.user.UserService;
import com.openexchange.userconf.UserPermissionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AdministrativeInfostoreFileAccess
extends InfostoreAccess
implements AdministrativeFileStorageFileAccess {
    private final Context context;

    public AdministrativeInfostoreFileAccess(InfostoreFacade infostore, Context context) {
        super(infostore);
        this.context = context;
    }

    public File getFileMetadata(String folderId, String id, String version) throws OXException {
        try {
            DocumentMetadata documentMetadata = this.getInfostore(folderId).getDocumentMetadata(AdministrativeInfostoreFileAccess.ID(id), AdministrativeInfostoreFileAccess.VERSION(version), this.context);
            if (null != folderId && documentMetadata.getFolderId() > 0L && !folderId.equals(Long.toString(documentMetadata.getFolderId()))) {
                throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
            }
            return new InfostoreFile(documentMetadata);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFileMetadata(File file, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        InfostoreFacade infostoreFacade = this.getInfostore(file.getFolderId());
        infostoreFacade.startTransaction();
        boolean committed = false;
        try {
            infostoreFacade.saveDocumentMetadata((DocumentMetadata)new FileMetadata(file), sequenceNumber, FieldMapping.getMatching(modifiedFields), this.context);
            infostoreFacade.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                infostoreFacade.rollback();
            }
            infostoreFacade.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(String folderId, String id) throws OXException {
        InfostoreFacade infostoreFacade = this.getInfostore(folderId);
        infostoreFacade.startTransaction();
        boolean committed = false;
        try {
            infostoreFacade.removeDocuments(Collections.singletonList(new FileStorageFileAccess.IDTuple(folderId, id)), this.context);
            infostoreFacade.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                infostoreFacade.rollback();
            }
            infostoreFacade.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocuments(List<FileStorageFileAccess.IDTuple> ids) throws OXException {
        ArrayList<InfostoreFacade> openedFacades;
        block10: {
            HashMap<String, LinkedList<FileStorageFileAccess.IDTuple>> idsByFolder = new HashMap<String, LinkedList<FileStorageFileAccess.IDTuple>>(ids.size());
            for (FileStorageFileAccess.IDTuple tuple : ids) {
                String folderId = tuple.getFolder();
                LinkedList<FileStorageFileAccess.IDTuple> fileIds = (LinkedList<FileStorageFileAccess.IDTuple>)idsByFolder.get(folderId);
                if (fileIds == null) {
                    fileIds = new LinkedList<FileStorageFileAccess.IDTuple>();
                    idsByFolder.put(folderId, fileIds);
                }
                fileIds.add(tuple);
            }
            openedFacades = new ArrayList<InfostoreFacade>(idsByFolder.size());
            boolean allCommitted = false;
            try {
                for (Map.Entry entry : idsByFolder.entrySet()) {
                    InfostoreFacade infostoreFacade = this.getInfostore((String)entry.getKey());
                    infostoreFacade.startTransaction();
                    openedFacades.add(infostoreFacade);
                    infostoreFacade.removeDocuments((List)entry.getValue(), this.context);
                    infostoreFacade.commit();
                }
                allCommitted = true;
                if (allCommitted) break block10;
            }
            catch (Throwable throwable) {
                if (!allCommitted) {
                    for (InfostoreFacade infostoreFacade : openedFacades) {
                        InfostoreFacades.rollback((InfostoreFacade[])new InfostoreFacade[]{infostoreFacade});
                    }
                }
                for (InfostoreFacade infostoreFacade : openedFacades) {
                    InfostoreFacades.finish((InfostoreFacade[])new InfostoreFacade[]{infostoreFacade});
                }
                throw throwable;
            }
            for (InfostoreFacade infostoreFacade : openedFacades) {
                InfostoreFacades.rollback((InfostoreFacade[])new InfostoreFacade[]{infostoreFacade});
            }
        }
        for (InfostoreFacade infostoreFacade : openedFacades) {
            InfostoreFacades.finish((InfostoreFacade[])new InfostoreFacade[]{infostoreFacade});
        }
    }

    public boolean exists(String folderId, String id, String version) throws OXException {
        return this.getInfostore(folderId).exists(AdministrativeInfostoreFileAccess.ID(id), AdministrativeInfostoreFileAccess.VERSION(version), this.context);
    }

    public boolean canRead(String folderId, String id, int userId) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        return this.getInfostore(folderId).hasDocumentAccess(AdministrativeInfostoreFileAccess.ID(id), InfostoreFacade.AccessPermission.READ, user, this.context);
    }

    public boolean canWrite(String folderId, String id, int userId) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        return this.getInfostore(folderId).hasDocumentAccess(AdministrativeInfostoreFileAccess.ID(id), InfostoreFacade.AccessPermission.WRITE, user, this.context);
    }

    public boolean canDelete(String folderId, String id, int userId) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        return this.getInfostore(folderId).hasDocumentAccess(AdministrativeInfostoreFileAccess.ID(id), InfostoreFacade.AccessPermission.DELETE, user, this.context);
    }

    public TimedResult<File> getDocuments(String folderId, int userId, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, Range range) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        UserPermissionBits permissionBits = Services.getService(UserPermissionService.class).getUserPermissionBits(userId, this.context);
        TimedResult timedResult = this.getInfostore(folderId).getDocuments((long)AdministrativeInfostoreFileAccess.ID(folderId), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), null != range ? range.from : -1, null != range ? range.to : -1, this.context, user, permissionBits);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)timedResult);
    }

    public void touch(String folderId, String id) throws OXException {
        this.getInfostore(folderId).touch(AdministrativeInfostoreFileAccess.ID(id), this.context);
    }
}

