/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.function.TObjectFunction;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TLongSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ConcurrentTLongObjectHashMap<V>
extends TLongObjectHashMap<V> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final TLongObjectHashMap<V> delegatee;

    public ConcurrentTLongObjectHashMap() {
        super(1);
        this.delegatee = new TLongObjectHashMap();
    }

    public ConcurrentTLongObjectHashMap(int initialCapacity) {
        super(1);
        this.delegatee = new TLongObjectHashMap(initialCapacity);
    }

    public ConcurrentTLongObjectHashMap(TLongObjectMap<? extends V> map) {
        super(1);
        this.delegatee = new TLongObjectHashMap(map);
    }

    public ConcurrentTLongObjectHashMap(int initialCapacity, float loadFactor) {
        super(1);
        this.delegatee = new TLongObjectHashMap(initialCapacity, loadFactor);
    }

    public ConcurrentTLongObjectHashMap(int initialCapacity, float loadFactor, long noEntryKey) {
        super(1);
        this.delegatee = new TLongObjectHashMap(initialCapacity, loadFactor, noEntryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int capacity() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.delegatee.capacity();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNoEntryValue() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            long l2 = this.delegatee.getNoEntryValue();
            return l2;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.delegatee.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long val) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.contains(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEach(TLongProcedure procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.forEach(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int desiredCapacity) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.ensureCapacity(desiredCapacity);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNoEntryKey() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            long l2 = this.delegatee.getNoEntryKey();
            return l2;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(long key) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object val) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.containsValue(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.compact();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Object object = this.delegatee.get(key);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long key, V value) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            Object object = this.delegatee.put(key, value);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(long key, V value) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            Object object = this.delegatee.putIfAbsent(key, value);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCompactionFactor(float factor) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            this.delegatee.setAutoCompactionFactor(factor);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            Object object = this.delegatee.remove(key);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends Long, ? extends V> map) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.putAll(map);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAutoCompactionFactor() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            float f = this.delegatee.getAutoCompactionFactor();
            return f;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(TLongObjectMap<? extends V> map) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.putAll(map);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLongSet keySet() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            TLongSet tLongSet = this.delegatee.keySet();
            return tLongSet;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] keys() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            long[] lArray = this.delegatee.keys();
            return lArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] keys(long[] dest) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            long[] lArray = this.delegatee.keys(dest);
            return lArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> valueCollection() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Collection collection = this.delegatee.valueCollection();
            return collection;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] values() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.delegatee.values();
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V[] values(V[] dest) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.delegatee.values((Object[])dest);
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tempDisableAutoCompaction() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            this.delegatee.tempDisableAutoCompaction();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenableAutoCompaction(boolean check_for_compaction) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.reenableAutoCompaction(check_for_compaction);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLongObjectIterator<V> iterator() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            TLongObjectIterator tLongObjectIterator = this.delegatee.iterator();
            return tLongObjectIterator;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachKey(TLongProcedure procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.forEachKey(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachValue(TObjectProcedure<? super V> procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.forEachValue(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachEntry(TLongObjectProcedure<? super V> procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.forEachEntry(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TLongObjectProcedure<? super V> procedure) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.delegatee.retainEntries(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformValues(TObjectFunction<V, V> function) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.transformValues(function);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.delegatee.equals(other);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.delegatee.hashCode();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            this.delegatee.writeExternal(out);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.delegatee.readExternal(in);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            String string = this.delegatee.toString();
            return string;
        }
        finally {
            l.unlock();
        }
    }
}

