/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.folder;

import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.GroupUserTest;
import java.util.Date;

public class UpdateTest
extends FolderTest {
    public UpdateTest(String name) {
        super(name);
    }

    public void testRenameFolder() throws Throwable {
        FolderObject folderObj = UpdateTest.createFolderObject(this.userId, "testInsertRenameFolder", 1, true);
        int objectId = UpdateTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj = new FolderObject();
        folderObj.setFolderName("testRenameFolder" + System.currentTimeMillis());
        folderObj.setObjectID(objectId);
        folderObj.setParentFolderID(2);
        UpdateTest.updateFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        FolderObject loadFolder = UpdateTest.loadFolder(this.webCon, objectId, "http://" + this.hostName, this.login, this.password, this.context);
        this.compareFolder(folderObj, loadFolder);
    }

    public void testMoveFolder() throws Exception {
        FolderObject folderObj = UpdateTest.createFolderObject(this.userId, "testMoveFolder1", 1, true);
        int parentFolderId = UpdateTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj = UpdateTest.createFolderObject(this.userId, "testMoveFolder2", 1, true);
        int objectId = UpdateTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj.setObjectID(objectId);
        folderObj.setParentFolderID(parentFolderId);
        UpdateTest.updateFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        FolderObject loadFolder = UpdateTest.loadFolder(this.webCon, objectId, "http://" + this.hostName, this.login, this.password, this.context);
        this.compareFolder(folderObj, loadFolder);
    }

    public void testChangePermissionsOfPrivateFolder() throws Exception {
        int userParticipantId = GroupUserTest.searchUser(this.webCon, this.userParticipant2, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context)[0].getInternalUserId();
        int groupParticipantId = GroupUserTest.searchGroup(this.webCon, this.groupParticipant, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context)[0].getIdentifier();
        FolderObject folderObj = UpdateTest.createFolderObject(this.userId, "testChangePermissionOfPrivateFolder", 1, false);
        int objectId = UpdateTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj.setObjectID(objectId);
        OCLPermission[] oclp = new OCLPermission[]{UpdateTest.createPermission(this.userId, false, 128, 128, 128, 128, true), UpdateTest.createPermission(userParticipantId, false, 4, 2, 4, 0, false), UpdateTest.createPermission(groupParticipantId, true, 4, 128, 128, 128, false)};
        folderObj.setPermissionsAsArray(oclp);
        UpdateTest.updateFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        FolderObject loadFolder = UpdateTest.loadFolder(this.webCon, objectId, "http://" + this.hostName, this.login, this.password, this.context);
        this.compareFolder(folderObj, loadFolder);
    }

    public void testChangePermissionsOfPublicFolder() throws Exception {
        int userParticipantId = GroupUserTest.searchUser(this.webCon, this.userParticipant2, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context)[0].getInternalUserId();
        int groupParticipantId = GroupUserTest.searchGroup(this.webCon, this.groupParticipant, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context)[0].getIdentifier();
        FolderObject folderObj = UpdateTest.createFolderObject(this.userId, "testChangePermissionOfPublicFolder", 1, true);
        int objectId = UpdateTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj.setObjectID(objectId);
        OCLPermission[] oclp = new OCLPermission[]{UpdateTest.createPermission(this.userId, false, 128, 128, 128, 128), UpdateTest.createPermission(userParticipantId, false, 4, 2, 4, 0), UpdateTest.createPermission(groupParticipantId, true, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(oclp);
        UpdateTest.updateFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        FolderObject loadFolder = UpdateTest.loadFolder(this.webCon, objectId, "http://" + this.hostName, this.login, this.password, this.context);
        this.compareFolder(folderObj, loadFolder);
    }
}

