/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.webdav.protocol.WebdavPath;
import java.util.Arrays;
import junit.framework.TestCase;

public class WebdavPathTest
extends TestCase {
    public void testStringConsturctor() {
        WebdavPath path = new WebdavPath((CharSequence)"/i/am/a/path");
        WebdavPathTest.assertComponents(path, "i", "am", "a", "path");
        path = new WebdavPath((CharSequence)"/i/am//a///path///");
        WebdavPathTest.assertComponents(path, "i", "am", "a", "path");
    }

    public void testStringsConstuctor() {
        WebdavPath path = new WebdavPath(new String[]{"i", "am", "a", "path"});
        WebdavPathTest.assertComponents(path, "i", "am", "a", "path");
    }

    public void testAppend() {
        WebdavPath path = new WebdavPath(new String[0]);
        path.append(new String[]{"i", "am", "a", "path"});
        WebdavPathTest.assertComponents(path, "i", "am", "a", "path");
        path = new WebdavPath(new String[0]);
        path.append(Arrays.asList("i", "am", "a", "path"));
        WebdavPathTest.assertComponents(path, "i", "am", "a", "path");
        path = new WebdavPath(new String[0]);
        path.append(new WebdavPath(new String[]{"i", "am", "a", "path"}));
        WebdavPathTest.assertComponents(path, "i", "am", "a", "path");
    }

    public void testToString() {
        WebdavPath path = new WebdavPath(new String[]{"i", "am", "a", "path"});
        WebdavPathTest.assertEquals((String)"/i/am/a/path", (String)path.toString());
    }

    public void testToEscapedString() {
        WebdavPath path = new WebdavPath(new String[]{"with/slash", "with\\backslash"});
        WebdavPathTest.assertEquals((String)"/with\\/slash/with\\\\backslash", (String)path.toEscapedString());
    }

    public void testEquals() {
        WebdavPath path = new WebdavPath((CharSequence)"/i/am/a/path");
        WebdavPath path2 = new WebdavPath(new String[]{"i", "am", "a", "path"});
        WebdavPath path3 = new WebdavPath(new String[0]);
        WebdavPathTest.assertEquals((Object)path, (Object)path2);
        WebdavPathTest.assertEquals((int)path.hashCode(), (int)path2.hashCode());
        WebdavPathTest.assertFalse((boolean)path.equals((Object)path3));
        WebdavPathTest.assertFalse((path.hashCode() == path3.hashCode() ? 1 : 0) != 0);
    }

    public void testParent() {
        WebdavPath path = new WebdavPath((CharSequence)"/i/am/a/path");
        WebdavPathTest.assertComponents(path.parent(), "i", "am", "a");
    }

    public void testName() {
        WebdavPath path = new WebdavPath((CharSequence)"/i/am/a/path");
        WebdavPathTest.assertEquals((String)"path", (String)path.name());
    }

    public void testStartsWith() {
        WebdavPath path = new WebdavPath((CharSequence)"/i/am/a/path");
        WebdavPath path2 = new WebdavPath((CharSequence)"/i/am/a");
        WebdavPath path3 = new WebdavPath((CharSequence)"/i/am/a/path/below");
        WebdavPath path4 = new WebdavPath((CharSequence)"/i/am/elsewhere");
        WebdavPathTest.assertTrue((boolean)path.startsWith(path2));
        WebdavPathTest.assertFalse((boolean)path.startsWith(path3));
        WebdavPathTest.assertFalse((boolean)path.startsWith(path4));
    }

    public void testSubpath() {
        WebdavPath path = new WebdavPath(new String[]{"i", "am", "a", "path"});
        WebdavPathTest.assertComponents(path.subpath(1), "am", "a", "path");
        WebdavPathTest.assertComponents(path.subpath(0, 2), "i", "am");
    }

    public static void assertComponents(WebdavPath path, String ... components) {
        WebdavPathTest.assertEquals((int)components.length, (int)path.size());
        int i = 0;
        for (String component : path) {
            WebdavPathTest.assertEquals((String)components[i++], (String)component);
        }
    }
}

