/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.infostore.integration;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.DummySessionHolder;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;

public class DropBoxScenarioTest
extends TestCase {
    private Context ctx;
    private String user1;
    private String user2;
    private InfostoreWebdavFactory factory = null;
    WebdavPath dropBox = null;
    List<WebdavPath> clean = new ArrayList<WebdavPath>();

    private static String getUsername(String un) {
        int pos = un.indexOf(64);
        return pos == -1 ? un : un.substring(0, pos);
    }

    public void setUp() throws Exception {
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.user1 = DropBoxScenarioTest.getUsername(config.getUser());
        this.user2 = DropBoxScenarioTest.getUsername(config.getSecondUser());
        TestWebdavFactoryBuilder.setUp();
        ContextStorage ctxstor = ContextStorage.getInstance();
        int contextId = ctxstor.getContextId(ctxName);
        this.ctx = ctxstor.getContext(contextId);
        this.factory = (InfostoreWebdavFactory)TestWebdavFactoryBuilder.buildFactory();
        this.factory.beginRequest();
        try {
            this.switchUser(this.user1);
            this.createDropBox();
        }
        catch (Exception x) {
            this.tearDown();
            throw x;
        }
    }

    @Test
    public void testAddToDropBox() {
        try {
            this.switchUser(this.user2);
            WebdavResource res = this.factory.resolveResource(this.dropBox.dup().append(new String[]{"testFile"}));
            res.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
            this.clean.add(this.dropBox.dup().append(new String[]{"testFile"}));
            res.create();
            this.switchUser(this.user1);
            res = this.factory.resolveResource(this.dropBox.dup().append(new String[]{"testFile"}));
            InputStream is = res.getBody();
            for (int i = 0; i < 10; ++i) {
                DropBoxScenarioTest.assertEquals((int)(i + 1), (int)is.read());
            }
            DropBoxScenarioTest.assertEquals((int)-1, (int)is.read());
            is.close();
        }
        catch (OXException e) {
            e.printStackTrace();
            DropBoxScenarioTest.fail((String)e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            DropBoxScenarioTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            DropBoxScenarioTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.switchUser(this.user1);
            for (WebdavPath url : this.clean) {
                this.factory.resolveResource(url).delete();
            }
        }
        finally {
            this.factory.endRequest(200);
            TestWebdavFactoryBuilder.tearDown();
        }
    }

    private void switchUser(String username) throws OXException, OXException, OXException, SQLException {
        this.factory.endRequest(200);
        this.factory.setSessionHolder((SessionHolder)new DummySessionHolder(username, this.ctx));
        this.factory.beginRequest();
    }

    private void createDropBox() throws OXException, OXException, OXException {
        Session session = this.factory.getSessionHolder().getSessionObject();
        OXFolderManager mgr = OXFolderManager.getInstance((Session)session);
        OXFolderAccess acc = new OXFolderAccess(ContextStorage.getInstance().getContext(session.getContextId()));
        FolderObject fo = acc.getDefaultFolder(session.getUserId(), 8);
        FolderObject newFolder = new FolderObject();
        newFolder.setFolderName("Drop Box " + System.currentTimeMillis());
        newFolder.setParentFolderID(fo.getObjectID());
        newFolder.setType(2);
        newFolder.setModule(8);
        ArrayList<OCLPermission> perms = new ArrayList<OCLPermission>();
        OCLPermission perm = new OCLPermission();
        perm.setEntity(session.getUserId());
        perm.setFolderAdmin(true);
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(4);
        perm.setWriteObjectPermission(4);
        perm.setDeleteObjectPermission(4);
        perm.setGroupPermission(false);
        perms.add(perm);
        perm = new OCLPermission();
        perm.setEntity(0);
        perm.setFolderAdmin(false);
        perm.setFolderPermission(4);
        perm.setReadObjectPermission(0);
        perm.setWriteObjectPermission(2);
        perm.setDeleteObjectPermission(0);
        perm.setGroupPermission(true);
        perms.add(perm);
        newFolder.setPermissions(perms);
        mgr.createFolder(newFolder, true, System.currentTimeMillis());
        this.dropBox = new WebdavPath(new String[]{"userstore", fo.getFolderName(), newFolder.getFolderName()});
        this.clean.add(this.factory.resolveCollection(this.dropBox).getUrl());
    }
}

