/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.action.WebdavUnlockAction;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;

public class UnlockTest
extends ActionTestCase {
    public void testUnlock() throws Exception {
        WebdavPath INDEX_HTML = this.testCollection.dup().append(new String[]{"index.html"});
        WebdavResource resource = this.factory.resolveResource(INDEX_HTML);
        WebdavLock lock = new WebdavLock();
        lock.setTimeout(-1L);
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        resource.lock(lock);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(INDEX_HTML);
        req.setHeader("Lock-Token", "<" + lock.getToken() + ">");
        WebdavUnlockAction action = new WebdavUnlockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        UnlockTest.assertEquals((int)200, (int)res.getStatus());
        UnlockTest.assertTrue((boolean)resource.getLocks().isEmpty());
    }
}

