/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.AbstractWebdavTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;

public class ICalTest
extends AbstractWebdavTest {
    protected Date startTime = null;
    protected Date endTime = null;
    private static final String ICAL_URL = "/servlet/webdav.ical";

    public ICalTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testUpload() throws Exception {
        GetMethodWebRequest initRequest = new GetMethodWebRequest("http://" + this.hostName + ICAL_URL);
        initRequest.setHeaderField("authorization", "Basic " + ICalTest.getAuthData(this.login, this.password, this.context));
        WebResponse initresponse = this.webCon.getResponse((WebRequest)initRequest);
        ICalTest.assertEquals((int)200, (int)initresponse.getResponseCode());
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:http://www.example.com/calendarapplication/\r\nMETHOD:PUBLISH\r\nBEGIN:VEVENT\r\nUID:461092315540@example.com\r\nORGANIZER;CN=\"Alice Balder, Example Inc.\":MAILTO:alice@example.com\r\nLOCATION:Somewhere\r\nSUMMARY:Eine Kurzinfo\r\nDESCRIPTION:Beschreibung des Termines\r\nCLASS:PUBLIC\r\nDTSTART:20060910T220000Z\r\nDTEND:20060919T215900Z\r\nDTSTAMP:20060812T125900Z\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(iCal.getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + this.hostName + ICAL_URL, (InputStream)byteArrayInputStream, "text/calendar");
        req.setHeaderField("authorization", "Basic " + ICalTest.getAuthData(this.login, this.password, this.context));
        WebResponse resp = this.webCon.getResponse((WebRequest)req);
        ICalTest.assertEquals((int)200, (int)resp.getResponseCode());
    }

    public void testDownload() throws Exception {
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + this.hostName + ICAL_URL);
        req.setHeaderField("authorization", "Basic " + ICalTest.getAuthData(this.login, this.password, this.context));
        WebResponse resp = this.webCon.getResponse((WebRequest)req);
        ICalTest.assertEquals((int)200, (int)resp.getResponseCode());
    }
}

