/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import com.openexchange.java.Charsets;
import com.openexchange.tools.encoding.URLCoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class URLParameter {
    private boolean multivalue = false;
    private final transient Map parameters;
    private final transient Map<String, List<String>> multivalueParameters;

    public URLParameter() {
        this.parameters = new HashMap();
        this.multivalueParameters = new HashMap<String, List<String>>();
    }

    public URLParameter(boolean multivalue) {
        this.multivalue = multivalue;
        this.parameters = new HashMap();
        this.multivalueParameters = new HashMap<String, List<String>>();
    }

    public void setParameter(String name, String value) {
        this.setParameter2Map(name, value);
    }

    public void setParameter(String name, int value) {
        this.setParameter2Map(name, String.valueOf(value));
    }

    public void setParameter(String name, long value) {
        this.setParameter2Map(name, String.valueOf(value));
    }

    public void setParameter(String name, boolean value) {
        this.setParameter2Map(name, String.valueOf(value));
    }

    public void setParameter(String name, Date value) {
        this.setParameter2Map(name, String.valueOf(value.getTime()));
    }

    private void setParameter2Map(String name, String value) {
        if (this.multivalue) {
            if (this.multivalueParameters.containsKey(name)) {
                List<String> l = this.multivalueParameters.get(name);
                l.add(value);
            } else {
                ArrayList<String> l = new ArrayList<String>();
                l.add(value);
                this.multivalueParameters.put(name, l);
            }
        } else {
            this.parameters.put(name, value);
        }
    }

    public String getURLParameters() throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        if (this.multivalue) {
            if (this.multivalueParameters.size() > 0) {
                sb.append('?');
            }
            Iterator<String> iter = this.multivalueParameters.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                List<String> l = this.multivalueParameters.get(name);
                for (int a = 0; a < l.size(); ++a) {
                    sb.append(URLCoder.encode((String)name, (Charset)Charsets.UTF_8));
                    sb.append('=');
                    sb.append(URLCoder.encode((String)l.get(a), (Charset)Charsets.UTF_8));
                    if (!iter.hasNext()) continue;
                    sb.append('&');
                }
            }
        } else {
            if (this.parameters.size() > 0) {
                sb.append('?');
            }
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                sb.append(URLCoder.encode((String)name, (Charset)Charsets.UTF_8));
                sb.append('=');
                sb.append(URLCoder.encode((String)((String)this.parameters.get(name)), (Charset)Charsets.UTF_8));
                if (!iter.hasNext()) continue;
                sb.append('&');
            }
        }
        return sb.toString();
    }

    public static String colsArray2String(int[] cols) {
        StringBuffer sb = new StringBuffer();
        for (int a = 0; a < cols.length; ++a) {
            if (a == 0) {
                sb.append(cols[a]);
                continue;
            }
            sb.append(',');
            sb.append(cols[a]);
        }
        return sb.toString();
    }
}

