/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.sql;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tx.ConfigurableDBProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class SQLTestCase
extends TestCase {
    private ConfigurableDBProvider dbProvider;
    protected Properties properties;

    public void setUp() throws Exception {
        this.loadProperties();
        this.dbProvider = new ConfigurableDBProvider();
        this.dbProvider.setDriver(this.getDriver());
        this.dbProvider.setLogin(this.getLogin());
        this.dbProvider.setPassword(this.getPassword());
        this.dbProvider.setUrl(this.getUrl());
    }

    public DBProvider getDBProvider() {
        return this.dbProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws IOException {
        String filename = System.getProperty("com.openexchange.test.sql.properties");
        if (filename == null) {
            filename = "conf/sql.properties";
            File f = new File(filename);
            if (!f.exists() || !f.canRead()) {
                filename = "testConf/sql.properties";
            }
            if (!(f = new File(filename)).exists() || !f.canRead()) {
                throw new IOException("Could not find suitable db conf file. Please put a sql.properties into either the conf or testConf directories or set the com.openexchange.test.sql.properties system property.");
            }
        }
        this.properties = new Properties();
        try (FileInputStream input = null;){
            input = new FileInputStream(filename);
            this.properties.load(input);
        }
    }

    public String getDriver() {
        return this.properties.getProperty("driver");
    }

    public String getLogin() {
        return this.properties.getProperty("login");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    public String getUrl() {
        return this.properties.getProperty("url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertResult(String sql) throws OXException, SQLException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            SQLTestCase.assertTrue((String)(sql + " had no result"), (boolean)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoResult(String sql) throws OXException, SQLException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            SQLTestCase.assertFalse((String)(sql + " had a result!"), (boolean)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String sql) throws SQLException, OXException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
        }
    }
}

